/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.datetime.DateAndTime;
import de.duehl.basics.datetime.Timestamp;
import de.duehl.basics.text.Text;
import java.util.List;

public class TimestampCorrector {
    private static final List<String> POSSIBLE_PICTURE_START_STRINGS = CollectionsHelper.buildListFrom("England_");
    private final int secondsToAdd;

    public TimestampCorrector(int n) {
        this.secondsToAdd = n;
    }

    public String correct(String string) {
        String string2 = this.determineKnownPartBeforeTimestamp(string);
        String string3 = Text.removeTextAtFrontIfStartsWith(string, string2);
        String string4 = string2 + this.correctInFilenameStartingWithTimestamp(string3);
        return string4;
    }

    private String determineKnownPartBeforeTimestamp(String string) {
        for (String string2 : POSSIBLE_PICTURE_START_STRINGS) {
            if (!string.startsWith(string2)) continue;
            return string2;
        }
        return "";
    }

    private String correctInFilenameStartingWithTimestamp(String string) {
        DateAndTime dateAndTime = new DateAndTime(Timestamp.getDateFromTimestamp(string), Timestamp.getTimeFromTimestamp(string));
        dateAndTime = dateAndTime.addSeconds(this.secondsToAdd);
        String string2 = dateAndTime.asYyyyMmDdDelimiterHhMmSs("_");
        return Timestamp.switchDateTimePartInName(string, string2);
    }
}

