/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.datetime.time;

import de.duehl.basics.datetime.time.TimeHelper;
import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;

public class ContinousTimeMeasurement {
    private static final long NO_TIME_MEASURING_YET = -1L;
    private long secondsOfLastTimeMeasurement = 0L;
    private long secondsOfFirstTimeMeasurement = -1L;
    private final StopWatch watch = new StopWatch();

    public void startTimeMeasuring() {
        this.watch.start();
    }

    public void stopTimeMeasuring() {
        this.watch.stop();
    }

    public String timeMeasurement() {
        if (this.watch.isStopped()) {
            throw new RuntimeException("Nicht timeMeasurement() nach stopTimeMeasuring() aufrufen!");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.watch.getTime()).append(" (");
        long l = this.watch.getTimeInSeconds();
        long l2 = l - this.secondsOfLastTimeMeasurement;
        this.secondsOfLastTimeMeasurement = l;
        String string = TimeHelper.secondsToHoursMinutesSeconds(l2);
        stringBuilder.append(string);
        if (-1L == this.secondsOfFirstTimeMeasurement) {
            this.secondsOfFirstTimeMeasurement = l;
            stringBuilder.append(" - 1. Messung");
        } else {
            String string2 = NumberString.percent(l2, this.secondsOfFirstTimeMeasurement);
            stringBuilder.append(" - ").append(Text.fillWithSpacesAtFront(string2, 9)).append("%");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String getRuntime() {
        return this.watch.getTime();
    }
}

