/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.textfile;

import de.duehl.basics.io.textfile.FullTextFileReader;
import de.duehl.basics.text.Text;
import java.util.ArrayList;
import java.util.List;

public class StringsFromTextFileReader {
    private final FullTextFileReader reader;
    private final String commentChar;
    private List<String> strings;
    private boolean quiet;
    private boolean includeBlankLinesIntoResult;
    private boolean trimLines;
    private boolean toLowerCase;
    private String outputLine;

    public StringsFromTextFileReader(FullTextFileReader fullTextFileReader, String string) {
        this.reader = fullTextFileReader;
        this.commentChar = string;
        this.quiet = false;
        this.includeBlankLinesIntoResult = false;
        this.trimLines = true;
        this.toLowerCase = false;
    }

    public void beQuiet() {
        this.quiet = true;
    }

    public void includeBlankLinesIntoResult() {
        this.includeBlankLinesIntoResult = true;
    }

    public void changeToLowerCase() {
        this.toLowerCase = true;
    }

    public void doNotTrimLines() {
        this.trimLines = false;
    }

    public List<String> read() {
        this.strings = new ArrayList<String>();
        if (this.quiet) {
            this.reader.beQuiet();
        }
        this.reader.read(string -> this.analyseLine(string));
        return this.strings;
    }

    private void analyseLine(String string) {
        String string2 = this.outputLine = this.trimLines ? string.trim() : string;
        if (this.doNotAnalyseLine()) {
            return;
        }
        this.removeCommentFromLine();
        this.toLowerCase();
        this.strings.add(this.outputLine);
    }

    private boolean doNotAnalyseLine() {
        return this.outputLine.isEmpty() && !this.includeBlankLinesIntoResult || this.outputLine.startsWith(this.commentChar);
    }

    private void removeCommentFromLine() {
        int n = this.outputLine.indexOf(this.commentChar);
        if (n > -1) {
            this.outputLine = this.outputLine.substring(0, n);
            if (this.trimLines) {
                this.outputLine = this.outputLine.trim();
            }
        }
    }

    private void toLowerCase() {
        if (this.toLowerCase) {
            this.outputLine = Text.toLowerCase(this.outputLine);
        }
    }

    public String getCommentChar() {
        return this.commentChar;
    }

    public String getFilename() {
        return this.reader.getFilename();
    }

    public int getLineNumber() {
        return this.reader.getLineNumber();
    }
}

