/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.textfile.data;

import de.duehl.basics.io.textfile.data.Definition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Definitions
implements Iterable<Definition> {
    private final List<Definition> definitions = new ArrayList<Definition>();
    private final Map<String, String> keyToValue = new HashMap<String, String>();

    public void add(Definition definition) {
        if (this.containsKey(definition)) {
            throw new RuntimeException("Der Schl\u00fcssel ist bereits bekannt: " + definition);
        }
        this.definitions.add(definition);
        this.keyToValue.put(definition.getKey(), definition.getValue());
    }

    boolean containsKeySlow(Definition definition) {
        for (Definition definition2 : this.definitions) {
            if (!definition2.hasSameKey(definition)) continue;
            return true;
        }
        return false;
    }

    boolean containsKeySlow(String string) {
        for (Definition definition : this.definitions) {
            if (!definition.getKey().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean containsKey(Definition definition) {
        return this.keyToValue.containsKey(definition.getKey());
    }

    public boolean containsKey(String string) {
        return this.keyToValue.containsKey(string);
    }

    public String getValueByKey(String string) {
        if (!this.containsKey(string)) {
            throw new RuntimeException("Unbekannter Schl\u00fcssel '" + string + "'!");
        }
        return this.keyToValue.get(string);
    }

    public int size() {
        return this.definitions.size();
    }

    public List<String> getKeys() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Definition definition : this.definitions) {
            arrayList.add(definition.getKey());
        }
        return arrayList;
    }

    @Override
    public Iterator<Definition> iterator() {
        return this.definitions.iterator();
    }

    public String toString() {
        return "Definitions : " + this.definitions;
    }
}

