/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.io.walker;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.io.walker.DirWalkerObserver;
import de.duehl.basics.text.Text;
import java.util.List;

public class TablePrintingDirWalkerObserver
implements DirWalkerObserver {
    private final String systemDisplayName;

    public TablePrintingDirWalkerObserver(String string) {
        this.systemDisplayName = FileHelper.getSystemDisplayName(string);
        this.printTitles();
    }

    private void printTitles() {
        List<String> list = CollectionsHelper.buildListFrom("System Display Name", "Bemerkung", "Pfad");
        this.printFields(list);
    }

    @Override
    public void visitFile(String string) {
        this.printLine("Datei", string);
    }

    @Override
    public void visitEmptyDir(String string) {
        this.printLine("leeres Verzeichnis", string);
    }

    private void printLine(String string, String string2) {
        List<String> list = CollectionsHelper.buildListFrom(this.systemDisplayName, string, string2);
        this.printFields(list);
    }

    private void printFields(List<String> list) {
        System.out.println(Text.joinWithTabulator(list));
    }

    @Override
    public void visitNotEmptyDir(String string) {
    }
}

