/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.replacements;

import de.duehl.basics.replacements.data.FoundPlaceholder;
import de.duehl.basics.text.NumberString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ReplacementsAnalyser {
    private final String text;
    private List<FoundPlaceholder> foundPlaceholders;
    private Map<String, List<FoundPlaceholder>> placeHoldersByName;
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("<<([-a-z]+):(\\d+)>>");

    public ReplacementsAnalyser(String string) {
        this.text = string;
    }

    public void analyse() {
        this.findPlaceholders();
        this.buildMap();
    }

    private void findPlaceholders() {
        this.foundPlaceholders = new ArrayList<FoundPlaceholder>();
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(this.text);
        while (matcher.find()) {
            int n = matcher.start();
            String string = matcher.group();
            String string2 = matcher.group(1);
            String string3 = matcher.group(2);
            int n2 = NumberString.parseInt(string3);
            FoundPlaceholder foundPlaceholder = new FoundPlaceholder(n, string, string2, n2);
            this.foundPlaceholders.add(foundPlaceholder);
        }
    }

    private void buildMap() {
        this.placeHoldersByName = new HashMap<String, List<FoundPlaceholder>>();
        for (FoundPlaceholder foundPlaceholder : this.foundPlaceholders) {
            String string = foundPlaceholder.getName();
            if (!this.placeHoldersByName.containsKey(string)) {
                this.placeHoldersByName.put(string, new ArrayList());
            }
            List<FoundPlaceholder> list = this.placeHoldersByName.get(string);
            list.add(foundPlaceholder);
        }
    }

    public void addReplacedTexts(String string, List<String> list) {
        if (!list.isEmpty()) {
            List<FoundPlaceholder> list2 = this.placeHoldersByName.get(string);
            for (FoundPlaceholder foundPlaceholder : list2) {
                int n = foundPlaceholder.getPosition();
                int n2 = n - 1;
                String string2 = list.get(n2);
                foundPlaceholder.setReplacedText(string2);
            }
        }
    }

    public boolean isEveryMapListIsSortedByPosition() {
        for (String string : this.placeHoldersByName.keySet()) {
            if (this.isListIsSortedByPosition(this.placeHoldersByName.get(string))) continue;
            return false;
        }
        return true;
    }

    private boolean isListIsSortedByPosition(List<FoundPlaceholder> list) {
        int n = 0;
        for (FoundPlaceholder foundPlaceholder : list) {
            int n2 = foundPlaceholder.getPosition();
            if (n + 1 != n2) {
                return false;
            }
            n = n2;
        }
        return true;
    }

    public List<FoundPlaceholder> getFoundPlaceholders() {
        return this.foundPlaceholders;
    }

    public Map<String, List<FoundPlaceholder>> getPlaceHoldersByName() {
        return this.placeHoldersByName;
    }
}

