/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.basics.text;

import de.duehl.basics.text.TextPosition;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class TextPositions {
    private final List<TextPosition> positions = new ArrayList<TextPosition>();

    public void add(TextPosition textPosition) {
        this.positions.add(textPosition);
    }

    public void sort() {
        Collections.sort(this.positions);
    }

    public TextPosition get(int n) {
        return this.positions.get(n);
    }

    public void removeOverlapping() {
        this.sort();
        boolean bl = true;
        while (bl) {
            bl = this.removeOverlappingOneTime();
            if (!bl) continue;
            this.sort();
        }
    }

    private boolean removeOverlappingOneTime() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        ArrayList<TextPosition> arrayList = new ArrayList<TextPosition>();
        boolean bl = this.findMeltingIndicesAndGenereateMeltedPositions(hashSet, arrayList);
        this.removeOldPositionsThatWereMelted(hashSet);
        this.addAllMeltedPositions(arrayList);
        return bl;
    }

    private boolean findMeltingIndicesAndGenereateMeltedPositions(Set<Integer> set, List<TextPosition> list) {
        for (int i = 0; i < this.positions.size(); ++i) {
            boolean bl = false;
            TextPosition textPosition = this.positions.get(i);
            for (int j = i + 1; j < this.positions.size(); ++j) {
                TextPosition textPosition2 = this.positions.get(j);
                if (!textPosition.overlapp(textPosition2)) continue;
                TextPosition textPosition3 = textPosition.meltWith(textPosition2);
                set.add(i);
                set.add(j);
                list.add(textPosition3);
                bl = true;
            }
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private void removeOldPositionsThatWereMelted(Set<Integer> set) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.addAll(set);
        Collections.sort(arrayList);
        Collections.reverse(arrayList);
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.positions.remove(n);
        }
    }

    private void addAllMeltedPositions(List<TextPosition> list) {
        this.positions.addAll(list);
    }

    public int size() {
        return this.positions.size();
    }
}

