/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.text.html.characteristic;

import de.duehl.swing.text.html.characteristic.OpticalTextPartCharacteristic;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.ColorTranslator;
import de.duehl.swing.ui.layout.VerticalLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

public class OpticalTextPartCharacteristicPanel {
    private static final int COMBOBOX_PART_WIDTH = 330;
    private final String description;
    private final Component windowAsComponent;
    private boolean useDescriptionOnlyInHeader;
    private final JButton foregroundColorChangeButton;
    private final JButton backgroundColorChangeButton;
    private Color foregroundColor;
    private Color backgroundColor;
    private final JCheckBox useBackgroundColorCheckBox;
    private final JCheckBox boldCheckBox;
    private final JCheckBox italicCheckBox;
    private final JCheckBox underlineCheckBox;

    public OpticalTextPartCharacteristicPanel(String string, Component component) {
        this.description = string;
        this.windowAsComponent = component;
        this.foregroundColorChangeButton = new JButton();
        this.backgroundColorChangeButton = new JButton();
        this.useBackgroundColorCheckBox = new JCheckBox();
        this.boldCheckBox = new JCheckBox();
        this.italicCheckBox = new JCheckBox();
        this.underlineCheckBox = new JCheckBox();
        this.useDescriptionOnlyInHeader = false;
    }

    public void useDescriptionOnlyInHeader() {
        this.useDescriptionOnlyInHeader = true;
    }

    public void initElements() {
        this.setTitles();
        this.foregroundColorChangeButton.addActionListener(actionEvent -> this.selectForegroundColor());
        this.backgroundColorChangeButton.addActionListener(actionEvent -> this.selectBackgroundColor());
    }

    private void setTitles() {
        String string = this.determineTitleFront();
        this.foregroundColorChangeButton.setText(string + "Vordergrundfarbe \u00e4ndern");
        this.backgroundColorChangeButton.setText(string + "Hintergrundfarbe \u00e4ndern");
        this.useBackgroundColorCheckBox.setText(string + "Hintergrundfarbe nutzen");
        this.boldCheckBox.setText(string + "fett darstellen");
        this.italicCheckBox.setText(string + "kursiv darstellen");
        this.underlineCheckBox.setText(string + "unterstrichen darstellen");
    }

    private String determineTitleFront() {
        if (this.useDescriptionOnlyInHeader) {
            return "";
        }
        return this.description + " - ";
    }

    private void selectForegroundColor() {
        Color color = JColorChooser.showDialog(this.windowAsComponent, this.description + " - Vordergrundfarbe im Text festlegen", this.foregroundColor);
        if (null != color) {
            this.foregroundColor = color;
            this.setButtonColors();
        }
    }

    private void selectBackgroundColor() {
        Color color = JColorChooser.showDialog(this.windowAsComponent, this.description + " - Hintergrundfarbe im Text festlegen", this.backgroundColor);
        if (null != color) {
            this.backgroundColor = color;
            this.setButtonColors();
        }
    }

    public Component createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createColorSelectionPart(), "Center");
        jPanel.add(this.createOptionsSelectionPart(), "East");
        return jPanel;
    }

    private Component createColorSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle(this.description + " - Farben", jPanel);
        jPanel.add(this.foregroundColorChangeButton);
        jPanel.add(this.backgroundColorChangeButton);
        jPanel.add(this.useBackgroundColorCheckBox);
        return jPanel;
    }

    private Component createOptionsSelectionPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new VerticalLayout(3, 3));
        GuiTools.createTitle(this.description + " - Textauszeichnung", jPanel);
        jPanel.add(this.boldCheckBox);
        jPanel.add(this.italicCheckBox);
        jPanel.add(this.underlineCheckBox);
        jPanel.setPreferredSize(new Dimension(330, 1));
        return jPanel;
    }

    public void fillOptionValuesIntoGui(OpticalTextPartCharacteristic opticalTextPartCharacteristic) {
        this.foregroundColor = ColorTranslator.hex2Swing(opticalTextPartCharacteristic.getForegroundHexColor());
        this.backgroundColor = ColorTranslator.hex2Swing(opticalTextPartCharacteristic.getBackgroundHexColor());
        this.useBackgroundColorCheckBox.setSelected(opticalTextPartCharacteristic.isUseBackgroundColor());
        this.boldCheckBox.setSelected(opticalTextPartCharacteristic.isBold());
        this.italicCheckBox.setSelected(opticalTextPartCharacteristic.isItalic());
        this.underlineCheckBox.setSelected(opticalTextPartCharacteristic.isUnderline());
        this.setButtonColors();
    }

    private void setButtonColors() {
        GuiTools.setForegroundAndBackground(this.foregroundColorChangeButton, this.foregroundColor);
        GuiTools.setForegroundAndBackground(this.backgroundColorChangeButton, this.backgroundColor);
    }

    public void apply(OpticalTextPartCharacteristic opticalTextPartCharacteristic) {
        opticalTextPartCharacteristic.setForegroundHexColor(ColorTranslator.swing2Hex(this.foregroundColor));
        opticalTextPartCharacteristic.setBackgroundHexColor(ColorTranslator.swing2Hex(this.backgroundColor));
        opticalTextPartCharacteristic.setUseBackgroundColor(this.useBackgroundColorCheckBox.isSelected());
        opticalTextPartCharacteristic.setBold(this.boldCheckBox.isSelected());
        opticalTextPartCharacteristic.setItalic(this.italicCheckBox.isSelected());
        opticalTextPartCharacteristic.setUnderline(this.underlineCheckBox.isSelected());
    }
}

