/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.elements;

import de.duehl.swing.ui.colors.Colorizer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class TextFieldWithTitle {
    private final JLabel titleLabel;
    private final JTextField textField;
    private final Component panel;

    public TextFieldWithTitle(String string) {
        this.titleLabel = new JLabel(string);
        this.textField = this.createTextField();
        this.panel = this.createPanel();
    }

    protected JTextField createTextField() {
        return new JTextField();
    }

    private Component createPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.titleLabel, this.getTitleBorderLayoutOrientation());
        jPanel.add((Component)this.textField, this.getTextFieldBorderLayoutOrientation());
        return jPanel;
    }

    protected String getTitleBorderLayoutOrientation() {
        return "North";
    }

    protected String getTextFieldBorderLayoutOrientation() {
        return "Center";
    }

    public Component getPanel() {
        return this.panel;
    }

    public void colorize(Colorizer colorizer) {
        colorizer.setColors(this.panel);
        colorizer.setColors(this.titleLabel);
        colorizer.setColors(this.textField);
    }

    public String getText() {
        return this.textField.getText().trim();
    }

    public void setText(String string) {
        this.textField.setText(string);
    }

    public void setPreferredSize(Dimension dimension) {
        this.textField.setPreferredSize(dimension);
    }

    public void addKeyListener(KeyListener keyListener) {
        this.textField.addKeyListener(keyListener);
    }

    public void addKeyReleasedAction(final Runnable runnable) {
        this.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                runnable.run();
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }
        });
    }

    public void addActionListener(ActionListener actionListener) {
        this.textField.addActionListener(actionListener);
    }

    public void setEnabled(boolean bl) {
        this.titleLabel.setEnabled(bl);
        this.textField.setEnabled(bl);
    }

    public void setEditable(boolean bl) {
        this.titleLabel.setEnabled(true);
        this.textField.setEnabled(true);
        this.textField.setEditable(bl);
    }
}

