/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.components.elements;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.elements.watch.StopWatchLabel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TitledStopWatchLabel {
    private final JLabel titleLabel;
    private final StopWatchLabel stopWatchLabel;
    private final Component panel;
    private final Dimension titleDimension;

    public TitledStopWatchLabel(Dimension dimension, Color color) {
        this(dimension, color, "");
    }

    public TitledStopWatchLabel(Dimension dimension, Color color, String string) {
        this.titleDimension = dimension;
        this.titleLabel = new JLabel(string);
        this.stopWatchLabel = new StopWatchLabel();
        this.stopWatchLabel.stop();
        this.stopWatchLabel.setForeground(color);
        this.panel = this.createTitledValue();
    }

    private Component createTitledValue() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createTitleLabel(), "West");
        jPanel.add((Component)this.stopWatchLabel, "Center");
        return jPanel;
    }

    private Component createTitleLabel() {
        this.titleLabel.setPreferredSize(this.titleDimension);
        return this.titleLabel;
    }

    public Component getPanel() {
        return this.panel;
    }

    public void setTitle(String string) {
        this.titleLabel.setText(string);
        this.panel.repaint();
    }

    public void useMonospacedFontForTheValue() {
        GuiTools.setMonospacedFont(this.stopWatchLabel);
        this.panel.repaint();
    }

    public void start() {
        this.stopWatchLabel.start();
    }

    public void setForeground(Color color) {
        this.stopWatchLabel.setForeground(color);
    }

    public void stop() {
        this.stopWatchLabel.stop();
    }

    public String getTime() {
        return this.stopWatchLabel.getTime();
    }
}

