/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.elements.fontsize;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.painted.MinusButton;
import de.duehl.swing.ui.buttons.painted.PlusButton;
import de.duehl.swing.ui.elements.box.ObservableComboBox;
import de.duehl.swing.ui.elements.fontsize.FontSizeInteraction;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class FontSizeSelection {
    private static final Dimension BUTTON_DIMENSION = new Dimension(20, 20);
    private static boolean WITH_LABEL = false;
    private final FontSizeInteraction fontSizeInteraction;
    private final JLabel fontSizeLabel;
    private final ObservableComboBox<String> fontSizeBox;
    private final JPanel panel;

    public FontSizeSelection(FontSizeInteraction fontSizeInteraction) {
        this.fontSizeInteraction = fontSizeInteraction;
        this.panel = new JPanel();
        this.fontSizeLabel = new JLabel();
        this.fontSizeBox = new ObservableComboBox();
        this.initFontSizeComboBox();
        this.populatePanel();
    }

    private void initFontSizeComboBox() {
        this.fontSizeBox.setEditable(true);
        this.fontSizeBox.addBoxSelectionChangeObserver(string -> this.boxSelectionChanged((String)string));
        this.fontSizeBox.setValues(CollectionsHelper.buildListFrom("8", "9", "10", "11", "12", "13", "14", "15", "16", "17", "18", "20", "24", "32", "38", "44"));
        this.fontSizeBox.showValue(Integer.toString(this.getActualFontSize()));
        this.fontSizeBox.setPreferredSize(new Dimension(50, 25));
    }

    private void boxSelectionChanged(String string) {
        if (NumberString.isDigitSequence(string)) {
            int n = NumberString.parseIntIgnore(string, this.getActualFontSize());
            this.fontSizeInteraction.setFontSize(n);
        }
    }

    private int getActualFontSize() {
        return this.fontSizeInteraction.getFontSize();
    }

    private void populatePanel() {
        this.panel.setLayout(new BorderLayout());
        if (WITH_LABEL) {
            this.panel.add(this.createFontSizePanelWithLabel(), "West");
            this.panel.add(this.fontSizeBox.getBox(), "Center");
        } else {
            this.panel.add(this.createFontSizePanelWithFontSizeBox(), "West");
        }
    }

    private Component createFontSizePanelWithLabel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 2, 2));
        jPanel.add(this.createPlusFontSizeButton());
        jPanel.add(this.createFontSizeLabel());
        jPanel.add(this.createMinusFontSizeButton());
        return jPanel;
    }

    private Component createFontSizePanelWithFontSizeBox() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createPlusFontSizeButton(), "West");
        jPanel.add(this.fontSizeBox.getBox(), "Center");
        jPanel.add(this.createMinusFontSizeButton(), "East");
        return jPanel;
    }

    private Component createPlusFontSizeButton() {
        PlusButton plusButton = new PlusButton();
        plusButton.setPreferredSize(BUTTON_DIMENSION);
        plusButton.addActionListener(actionEvent -> this.incrementFontSize());
        return plusButton;
    }

    private void incrementFontSize() {
        this.fontSizeInteraction.incrementFontSize();
        this.refreshFontSize();
    }

    private Component createFontSizeLabel() {
        GuiTools.biggerFont(this.fontSizeLabel, 3);
        this.refreshFontSize();
        return this.fontSizeLabel;
    }

    public void refreshFontSize() {
        String string = Integer.toString(this.getActualFontSize());
        this.fontSizeLabel.setText(string);
        this.fontSizeBox.showValue(string);
        this.fontSizeBox.validate();
    }

    private Component createMinusFontSizeButton() {
        MinusButton minusButton = new MinusButton();
        minusButton.setPreferredSize(BUTTON_DIMENSION);
        minusButton.addActionListener(actionEvent -> this.decrementFontSize());
        return minusButton;
    }

    private void decrementFontSize() {
        this.fontSizeInteraction.decrementFontSize();
        this.refreshFontSize();
    }

    public void createBorder() {
        GuiTools.createTitle(this.panel);
    }

    public Component getComponent() {
        return this.panel;
    }
}

