/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.filter.dialog.creation;

import de.duehl.swing.ui.filter.dialog.FilterCombinationLine;
import de.duehl.swing.ui.filter.exceptions.FilterException;
import de.duehl.swing.ui.filter.method.FilterMethodFabricable;
import de.duehl.swing.ui.filter.method.combination.CombinationElement;
import de.duehl.swing.ui.filter.method.combination.CombinationElementFabric;
import de.duehl.swing.ui.filter.method.combination.CombinationElementList;
import de.duehl.swing.ui.filter.project.gateway.DescriptionToTypeTranslater;
import java.util.List;

public class RealFilterCreater<Data, Type> {
    private static final boolean VERBOSE = false;
    private final FilterMethodFabricable<Data, Type> methodFabric;
    private final List<FilterCombinationLine<Data, Type>> lines;
    private final DescriptionToTypeTranslater<Type> descriptionTranslater;

    public RealFilterCreater(FilterMethodFabricable<Data, Type> filterMethodFabricable, List<FilterCombinationLine<Data, Type>> list, DescriptionToTypeTranslater<Type> descriptionToTypeTranslater) {
        this.methodFabric = filterMethodFabricable;
        this.lines = list;
        this.descriptionTranslater = descriptionToTypeTranslater;
    }

    public CombinationElementList<Data> createRealFilter() {
        CombinationElement<Data> combinationElement;
        int n;
        CombinationElementList<Data> combinationElementList = this.createPreliminaryElementList();
        this.say("preliminary element List: " + combinationElementList);
        int n2 = -1;
        boolean bl = true;
        while (bl) {
            ++n2;
            while (!combinationElementList.get(n2).isUnion()) {
                if (++n2 < combinationElementList.size()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            n = this.getStartPositionOfLeftOperand(combinationElementList, n2);
            combinationElement = combinationElementList.remove(n2);
            combinationElementList.add(n, combinationElement);
            this.say("Verschiebe Vereinigung von " + n2 + " nach " + n + ".");
        }
        this.say("preliminary element List nach Verschieben der Vereinigungen: " + combinationElementList);
        n2 = -1;
        bl = true;
        while (bl) {
            ++n2;
            while (!combinationElementList.get(n2).isIntersection()) {
                if (++n2 < combinationElementList.size()) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            n = this.getStartPositionOfLeftOperand(combinationElementList, n2);
            this.say("W\u00fcrde Schnittbildung von " + n2 + " nach " + n + " verschieben.");
            n = this.jumpOverNOperandsAndUnionsToLeft(combinationElementList, n);
            combinationElement = combinationElementList.remove(n2);
            combinationElementList.add(n, combinationElement);
            this.say("Verschiebe Schnittbildung von " + n2 + " nach " + n + ".");
        }
        return combinationElementList;
    }

    private CombinationElementList<Data> createPreliminaryElementList() {
        CombinationElementList<Data> combinationElementList = new CombinationElementList<Data>();
        CombinationElementFabric<Data, Object> combinationElementFabric = new CombinationElementFabric<Data, Object>(this.methodFabric);
        this.say("---------------------------");
        for (FilterCombinationLine<Data, Type> filterCombinationLine : this.lines) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (filterCombinationLine.isMethodLine()) {
                object4 = filterCombinationLine.getMethodDescription();
                if (null == object4) {
                    throw new FilterException("Bekomme zu Methodenzeile keinen Typ");
                }
                object3 = this.descriptionTranslater.getTypeForDescription((String)object4);
                object2 = combinationElementFabric.createMethod(object3);
                combinationElementList.add((CombinationElement<Data>)object2);
                this.say("F\u00fcge type " + object3 + " hinzu.");
                continue;
            }
            if (filterCombinationLine.isNegatedMethodLine()) {
                object4 = combinationElementFabric.createNegation();
                combinationElementList.add((CombinationElement<Data>)object4);
                this.say("F\u00fcge 'nicht' hinzu.");
                object3 = filterCombinationLine.getMethodDescription();
                if (null == object3) {
                    throw new FilterException("Bekomme zu Methodenzeile keine Beschreibung.");
                }
                object2 = this.descriptionTranslater.getTypeForDescription((String)object3);
                object = combinationElementFabric.createMethod(object2);
                combinationElementList.add((CombinationElement<Data>)object);
                this.say("F\u00fcge type " + object2 + " hinzu.");
                continue;
            }
            if (filterCombinationLine.isParamisedMethodLine()) {
                object4 = filterCombinationLine.getMethodDescription();
                if (null == object4) {
                    throw new FilterException("Bekomme zu parametrisierter Methodenzeile keine Bescheibung.");
                }
                object3 = this.descriptionTranslater.getTypeForDescription((String)object4);
                object2 = filterCombinationLine.getParameter();
                if ("".equals(object2)) {
                    throw new FilterException("Bekomme zu parametrisierter Methodenzeile leeren Parameter");
                }
                object = combinationElementFabric.createInputMethod(object3, (String)object2);
                combinationElementList.add((CombinationElement<Data>)object);
                this.say("F\u00fcge type " + object3 + " mit Parameter '" + (String)object2 + "' hinzu.");
                continue;
            }
            if (filterCombinationLine.isParamisedNegatedMethodLine()) {
                object4 = combinationElementFabric.createNegation();
                combinationElementList.add((CombinationElement<Data>)object4);
                this.say("F\u00fcge 'nicht' hinzu.");
                object3 = filterCombinationLine.getMethodDescription();
                if (null == object3) {
                    throw new FilterException("Bekomme zu parametrisierter Methodenzeile keine Beschreibung.");
                }
                object2 = this.descriptionTranslater.getTypeForDescription((String)object3);
                object = filterCombinationLine.getParameter();
                if ("".equals(object)) {
                    throw new FilterException("Bekomme zu parametrisierter Methodenzeile leeren Parameter");
                }
                CombinationElement<Data> combinationElement = combinationElementFabric.createInputMethod(object2, (String)object);
                combinationElementList.add(combinationElement);
                this.say("F\u00fcge type " + object2 + " mit Parameter '" + (String)object + "' hinzu.");
                continue;
            }
            if (filterCombinationLine.isBraceOpenLine()) {
                object4 = combinationElementFabric.createOpeningBrace();
                combinationElementList.add((CombinationElement<Data>)object4);
                this.say("F\u00fcge '(' hinzu.");
                continue;
            }
            if (filterCombinationLine.isNegatedBraceOpenLine()) {
                object4 = combinationElementFabric.createNegation();
                combinationElementList.add((CombinationElement<Data>)object4);
                this.say("F\u00fcge 'nicht' hinzu.");
                object3 = combinationElementFabric.createOpeningBrace();
                combinationElementList.add((CombinationElement<Data>)object3);
                this.say("F\u00fcge '(' hinzu.");
                continue;
            }
            if (filterCombinationLine.isBraceCloseLine()) {
                object4 = combinationElementFabric.createClosingBrace();
                combinationElementList.add((CombinationElement<Data>)object4);
                this.say("F\u00fcge ')' hinzu.");
                continue;
            }
            if (filterCombinationLine.isIntersectionLine()) {
                object4 = combinationElementFabric.createIntersection();
                combinationElementList.add((CombinationElement<Data>)object4);
                this.say("F\u00fcge 'geschnitten mit' hinzu.");
                continue;
            }
            if (!filterCombinationLine.isUnionLine()) continue;
            object4 = combinationElementFabric.createUnion();
            combinationElementList.add((CombinationElement<Data>)object4);
            this.say("F\u00fcge 'vereinigt mit' hinzu.");
        }
        this.say("---------------------------");
        return combinationElementList;
    }

    private int getStartPositionOfLeftOperand(CombinationElementList<Data> combinationElementList, int n) {
        int n2 = n;
        if (n == 0) {
            throw new FilterException("Zweistelliger Operator an erster Stelle gefunden.");
        }
        int n3 = n - 1;
        CombinationElement<Data> combinationElement = combinationElementList.get(n3);
        if (combinationElement.isMethod()) {
            n2 = n3;
            if (n2 > 0 && combinationElementList.get(n2 - 1).isNegation()) {
                --n2;
            }
        } else if (combinationElement.isClosingBrace() && (n2 = this.findMatchingLeftBrace(combinationElementList, n3)) > 0 && combinationElementList.get(n2 - 1).isNegation()) {
            --n2;
        }
        return n2;
    }

    private int findMatchingLeftBrace(CombinationElementList<Data> combinationElementList, int n) {
        int n2;
        int n3 = 1;
        for (n2 = n - 1; n2 >= 0; --n2) {
            CombinationElement<Data> combinationElement = combinationElementList.get(n2);
            if (combinationElement.isClosingBrace()) {
                ++n3;
                continue;
            }
            if (combinationElement.isOpeningBrace() && 0 == --n3) break;
        }
        return n2;
    }

    private int jumpOverNOperandsAndUnionsToLeft(CombinationElementList<Data> combinationElementList, int n) {
        int n2;
        int n3 = n;
        boolean bl = n3 > 0;
        int n4 = 0;
        while (bl) {
            n2 = this.getStartPositionOfLeftOperand(combinationElementList, n3);
            if (n2 == n3) {
                bl = false;
                continue;
            }
            ++n4;
            n3 = n2;
        }
        n2 = 1;
        for (int i = 1; i <= n4; ++i) {
            int n5 = n3 - i;
            if (n5 >= 0) continue;
            n2 = 0;
            break;
        }
        n3 = n2 != 0 ? (n3 -= n4) : n;
        return n3;
    }

    private void say(String string) {
    }
}

