/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.highlightingeditor.unused;

import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import javax.swing.text.Element;

public class EditorCaretListener
implements CaretListener {
    private final JTextPane editor;
    private final JScrollPane scroll;
    private final Document document;
    private final JScrollBar verticalScroll;
    private int lastLine = -1;
    private int caretPosition;
    private int currentLine;
    private boolean reactOnChanges;

    public EditorCaretListener(JTextPane jTextPane, JScrollPane jScrollPane) {
        this.editor = jTextPane;
        this.scroll = jScrollPane;
        this.doNotReactOnChanges();
        this.document = jTextPane.getDocument();
        this.verticalScroll = jScrollPane.getVerticalScrollBar();
    }

    public void reactOnChanges() {
        this.reactOnChanges = true;
    }

    public void doNotReactOnChanges() {
        this.reactOnChanges = false;
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (this.reactOnChanges) {
            this.doCaretUpdate();
        }
    }

    private void doCaretUpdate() {
        this.caretPosition = this.editor.getCaretPosition();
        Element element = this.document.getDefaultRootElement();
        this.currentLine = element.getElementIndex(this.caretPosition);
        if (this.lastLine != this.currentLine) {
            this.lastLine = this.currentLine;
            this.reallyUpdate();
        }
    }

    private void reallyUpdate() {
        int n = this.document.getStartPosition().getOffset();
        int n2 = this.document.getEndPosition().getOffset();
        System.out.println("------------------------------------");
        System.out.println("startPosition =  " + n);
        System.out.println("endPosition =  " + n2);
        System.out.println("caretPosition =  " + this.caretPosition);
        System.out.println("Bin in Zeile " + this.currentLine);
        int n3 = this.verticalScroll.getMinimum();
        int n4 = this.verticalScroll.getMaximum();
        float f = this.caretPosition - n;
        float f2 = n2 - n;
        float f3 = n4 - n3;
        double d = (float)n3 + f / f2 * f3;
        int n5 = (int)d;
        this.scroll.getVerticalScrollBar().setValue(n5);
    }
}

