/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.highlightingeditor.userinput;

import de.duehl.swing.ui.highlightingeditor.multiplereactor.ChangeReactor;
import de.duehl.swing.ui.highlightingeditor.userinput.EditorForReactAfterUserInput;
import de.duehl.swing.ui.timer.WaitingUserInputTimerOperator;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ReactAfterUserInput
extends WaitingUserInputTimerOperator
implements ChangeReactor {
    private static final boolean DEBUG = false;
    private final EditorForReactAfterUserInput editor;
    private boolean reactOnChanges;

    public ReactAfterUserInput(long l, EditorForReactAfterUserInput editorForReactAfterUserInput) {
        super(l);
        this.editor = editorForReactAfterUserInput;
        editorForReactAfterUserInput.addDocumentListener(this.createWaitingDocumentListener());
        this.doNotReactOnChanges();
    }

    @Override
    public void reactOnChanges() {
        this.reactOnChanges = true;
    }

    @Override
    public void doNotReactOnChanges() {
        this.reactOnChanges = false;
    }

    private DocumentListener createWaitingDocumentListener() {
        return new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                this.warnAboutUserInput();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                this.warnAboutUserInput();
            }

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                this.warnAboutUserInput();
            }

            private void warnAboutUserInput() {
                if (ReactAfterUserInput.this.reactOnChanges) {
                    ReactAfterUserInput.this.reactOnDocumentChanges();
                }
            }
        };
    }

    private void reactOnDocumentChanges() {
        this.say("Usereingabe erkannt!");
        SwingUtilities.invokeLater(() -> this.editor.signChangedState());
        this.startTimer();
    }

    @Override
    protected Runnable createRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                ReactAfterUserInput.this.say("    -> SyntaxHighlightung nach Usereingabe!");
                SwingUtilities.invokeLater(() -> ReactAfterUserInput.this.editor.reactAfterUserInput());
            }
        };
    }

    private void say(String string) {
    }
}

