/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.selector;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.buttons.JobButton;
import de.duehl.swing.ui.selector.StartPoint;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class Selector {
    private static final Point LOCATION = new Point(100, 75);
    private final JFrame frame;
    private final int gridWidth;
    private final Image programImage;

    public Selector(int n) {
        this(n, null);
    }

    public Selector(int n, Image image) {
        this.gridWidth = n;
        this.programImage = image;
        GuiTools.setNiceLayoutManager();
        this.frame = new JFrame();
    }

    public void createGui(final List<StartPoint> list) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Selector.this.createGuiInternal(list);
            }
        });
    }

    private void createGuiInternal(List<StartPoint> list) {
        this.frame.setLayout(new BorderLayout());
        this.frame.setTitle("Welches Programm m\u00f6chten Sie starten?");
        this.frame.setDefaultCloseOperation(3);
        if (null != this.programImage) {
            this.frame.setIconImage(this.programImage);
        }
        JPanel jPanel = new JPanel();
        this.frame.add((Component)jPanel, "Center");
        jPanel.setLayout(new GridLayout(0, this.gridWidth, 10, 10));
        jPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        for (StartPoint startPoint : list) {
            jPanel.add(this.createStartButton(startPoint));
        }
        this.frame.setLocation(LOCATION);
        this.frame.pack();
    }

    private Component createStartButton(final StartPoint startPoint) {
        JButton jButton = this.createButton(startPoint.getDescription());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Selector.this.close();
                new Thread(startPoint.getRunnable()).start();
            }
        });
        return jButton;
    }

    private void close() {
        this.frame.setVisible(false);
        this.frame.dispose();
    }

    private JButton createButton(String string) {
        return new JobButton("<html><center>" + string + "</center></html>");
    }

    public void setVisible(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Selector.this.frame.setVisible(bl);
            }
        });
    }

    public Point getLocation() {
        return LOCATION;
    }
}

