/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.swing.ui.text.html;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.colors.Colorizer;
import de.duehl.swing.ui.text.html.HtmlComponent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.net.URL;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

class HtmlPanel {
    private static final int NOT_STORED_VERTICAL_SCROLLBAR_VALUE = -1;
    private final HtmlComponent htmlComponent = new HtmlComponent();
    private final JScrollPane scroll = new JScrollPane(this.htmlComponent.getComponent());
    private int storedVerticalScrollbarValue = -1;
    private int storedMaximumVerticalScrollbarValue = -1;

    HtmlPanel() {
    }

    public void showHtml(URL uRL) {
        this.htmlComponent.showHtml(uRL);
    }

    public void setText(String string) {
        this.htmlComponent.setText(string);
    }

    public int getTextLength() {
        return this.htmlComponent.getTextLength();
    }

    public void setPreferredSize(int n, int n2) {
        this.scroll.setPreferredSize(new Dimension(n, n2));
    }

    public void setColors(Colorizer colorizer) {
        if (null != colorizer) {
            this.htmlComponent.setColors(colorizer);
            colorizer.setColors(this.scroll);
        }
    }

    public void setDragEnabled(boolean bl) {
        this.htmlComponent.setDragEnabled(bl);
    }

    public void setCaretPosition(int n) {
        this.htmlComponent.setCaretPosition(n);
    }

    public int getCaretPosition() {
        return this.htmlComponent.getCaretPosition();
    }

    public Rectangle getVisibleRect() {
        return this.htmlComponent.getVisibleRect();
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        this.htmlComponent.scrollRectToVisible(rectangle);
    }

    public int getSelectionStart() {
        return this.htmlComponent.getSelectionStart();
    }

    public int getSelectionEnd() {
        return this.htmlComponent.getSelectionEnd();
    }

    public void setSelectionStart(int n) {
        this.htmlComponent.setSelectionStart(n);
    }

    public void setSelectionEnd(int n) {
        this.htmlComponent.setSelectionEnd(n);
    }

    public String getSelectedText() {
        return this.htmlComponent.getSelectedText();
    }

    public void clearSelection() {
        this.htmlComponent.clearSelection();
    }

    public Component getComponent() {
        return this.scroll;
    }

    public void scrollScrollbarToMinimumLater() {
        GuiTools.scrollScrollbarToMinimumLater(this.scroll);
    }

    public void scrollScrollbarToMaximumLater() {
        GuiTools.scrollScrollbarToMaximumLater(this.scroll);
    }

    public void scrollScrollbarToPreviousSectionLater() {
        GuiTools.scrollScrollbarToPreviousSectionLater(this.scroll);
    }

    public void scrollScrollbarToNextSectionLater() {
        GuiTools.scrollScrollbarToNextSectionLater(this.scroll);
    }

    public void repaint() {
        this.htmlComponent.repaint();
        this.scroll.validate();
    }

    public boolean hasFocus() {
        return this.htmlComponent.hasFokus();
    }

    public void setBackground(Color color) {
        this.htmlComponent.setBackground(color);
    }

    public void ignorePageUpAndPageDown() {
        this.htmlComponent.ignorePageUpAndPageDown();
        GuiTools.ignorePageUpAndPageDownInComponent(this.scroll);
    }

    public void ignoreUpAndDown() {
        this.htmlComponent.ignoreUpAndDown();
        GuiTools.ignoreUpAndDownInComponent(this.scroll);
    }

    public void ignoreCtrlPos1AndCtrlEnd() {
        this.htmlComponent.ignoreCtrlPos1AndCtrlEnd();
        GuiTools.ignoreCtrlPos1AndCtrlEndInComponent(this.scroll);
    }

    public void showCursor() {
        this.htmlComponent.showCursor();
    }

    public void storeVerticalPosition() {
        JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
        this.storedVerticalScrollbarValue = jScrollBar.getValue();
        this.storedMaximumVerticalScrollbarValue = jScrollBar.getMaximum();
    }

    public void restoreVerticalPosition() {
        if (this.storedVerticalScrollbarValue != -1 && this.storedMaximumVerticalScrollbarValue != -1) {
            int n = this.storedVerticalScrollbarValue;
            JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
            int n2 = jScrollBar.getMaximum();
            if (n > n2) {
                n = n2;
            }
            this.restoreVerticalPositionLater(n);
        }
    }

    private void restoreVerticalPositionLater(int n) {
        JScrollBar jScrollBar = this.scroll.getVerticalScrollBar();
        SwingUtilities.invokeLater(() -> jScrollBar.setValue(n));
    }

    public String getHtmlText() {
        return this.htmlComponent.getHtmlText();
    }
}

