/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.common.persistence;

import de.duehl.basics.io.FileHelper;
import de.duehl.basics.persistence.SessionManagerHelper;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.handling.BooleanHandling;
import de.duehl.basics.version.Version;
import de.duehl.swing.persistance.SwingSessionManagerHelper;
import de.duehl.vocabulary.japanese.common.color.data.ColorModificationType;
import de.duehl.vocabulary.japanese.common.data.TranslationDirection;
import de.duehl.vocabulary.japanese.common.data.VocablesShuffleType;
import de.duehl.vocabulary.japanese.common.data.VocablesSubsetSelectionType;
import de.duehl.vocabulary.japanese.common.data.VocabularySortOrder;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.data.EmptyTranslationsAcceptance;
import de.duehl.vocabulary.japanese.common.persistence.data.HistoricalOwnListPersistanceDataList;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.util.List;
import java.util.Properties;

public class SessionManager {
    private static final String STRING_SELECTION_FONT_SIZE = "options.stringSelectionFontSize";
    private static final String STRING_SELECTION_LABEL_FONT_SIZE = "options.stringSelectionLabelFontSize";
    private static final String LAST_USED_VERSION = "options.lastUsedVersion";
    private static final String VOCABULARIES_PATH = "options.vocabulariesPath";
    private static final String SWITCH_TO_NEXT_VOCABLE = "options.switchToNextVocableAfterEntringTranslation";
    private static final String SHOW_ROMAJI = "options.showRomajiWhenTestingVocable";
    private static final String SHOW_PRONUNCIATION = "options.showPronunciationWhenTestingVocable";
    private static final String SHOW_COMMENT = "options.showCommentWhenTestingVocable";
    private static final String SHOW_VOCABULARY_DESCRIPTION = "options.showVocabularyDescriptionWhenTestingVocable";
    private static final String BACKGROUND_COLORING_TESTING = "options.colorVocableDependingOnLastSuccessWhenTestingVocable";
    private static final String BACKGROUND_COLORING_VIEWING = "options.colorVocableDependingOnLastSuccessWhenViewingVocable";
    private static final String VOCABULARY_SORT_ORDER = "options.vocabularySortOrder";
    private static final String FOREGROUND_COLORING_VOCABULARY = "options.colorVocabularyDependingOnLastSuccess";
    private static final String VOCABLES_SHUFFLE_TYPE = "options.vocablesShuffleType";
    private static final String VOCABLES_SUBSET_SELECTION_TYPE = "options.vocablesSubsetSelectionType";
    private static final String REVERSE_SHUFFLED_VOCABLES = "options.reverseShuffledVocables";
    private static final String USE_VOCABLES_SHUFFLE_TYPE_FOR_LISTS = "options.useVocablesShuffleTypeForShowingListsAndSheetsToo";
    private static final String HIDE_START_OF_VOCABULARY = "options.hideStartOfVocabularyDescription";
    private static final String USE_TEST_ORDER_FOR_VIEWING = "options.useTestOrderForViewingVocables";
    private static final String LAST_SHOWN_MAIN_TAB_INDEX = "options.lastShownMainTabIndex";
    private static final String LAST_SHOWN_VOCABULARY_CATEGORY_TAB_INDEX = "options.lastShownVocabularyCategoryTabIndex";
    private static final String LAST_SHOWN_OWN_LIST_CATEGORY_TAB_INDEX = "options.lastShownOwnListCategoryTabIndex";
    private static final String LAST_SHOWN_VOCABULARY_SUB_CATEGORY_TAB_INDEX = "options.lastShownVocabularySubCategoryTabIndex";
    private static final String LAST_SHOWN_OWN_LIST_SUB_CATEGORY_TAB_INDEX = "options.lastShownOwnListSubCategoryTabIndex";
    private static final String SHOW_SUCCESS_PERCENT_IN_VOCABULARY_BAR = "options.showSuccessPercentInVocabularyBar";
    private static final String NUMBER_OF_VOCABULARY_BAR_COLUMNS = "options.numberOfVocabularyBarColumns";
    private static final String LAST_USED_OWN_LIST_DIRECTORY = "options.lastUsedOwnListImportExportDirectory";
    private static final String NUMBER_OF_DATASETS_PER_PAGE_OLE = "options.numberOfDatasetsPerPageOfOwnListEditor";
    private static final String NUMBER_OF_COLUMNS_OLE = "options.numberOfColumnsOfOwnListEditor";
    private static final String LOCATION_OF_OLE = "options.locationOfOwnListEditor";
    private static final String SIZE_OF_OLE = "options.sizeOfOwnListEditor";
    private static final String HIDE_VOCABLES_FROM_LIST_OLE = "options.hideVocablesFromListInSearchAreaInOwnListEditor";
    private static final String ALLOW_MISSING_MP3 = "options.allowMissingMp3";
    private static final String REPORT_MISSING_MP3 = "options.reportMissingMp3";
    private static final String NUMBER_OF_COLUMNS_OF_BLATT = "options.numberOfColumnsOfBlattDarstellung";
    private static final String INFORM_ABOUT_DOUBLE_MP3 = "options.informAboutDoubleMp3AtStartup";
    private static final String ONLY_USE_FIRST_GERMAN_TERM_TESTING = "options.useOnlyFirstGermanTermWhenTestingVocableGermanToJapanese";
    private static final String TRANSLATION_DIRECTION = "options.translationDirection";
    private static final String SHOW_KANJI = "options.showKanjiWhenTestingVocable";
    private static final String HIDE_KANJI_IF_HIRAGANA = "options.hideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana";
    private static final String HIDE_ROMAJI_IF_HIRAGANA = "options.hideRomajiWhenTestingVocableAndKanaContainsOnlyHiragana";
    private static final String HIDE_PRONUNCIATION_IF_HIRAGANA = "options.hidePronunciationWhenTestingVocableAndKanaContainsOnlyHiragana";
    private static final String SHOW_DETAILS_BUTTON_EINZELDARSTELLUNG = "options.showDetailsButtonInEinzeldarstellung";
    private static final String SHOW_DETAILS_BUTTON_VOKABELBLATTDARSTELLUNG = "options.showDetailsButtonInVokabelblattDarstellung";
    private static final String HIDE_LESS_START_OF_VOCABULARY_DESCRIPTION_VHS = "options.hideLessStartOfVocabularyDescriptionForVhs";
    private static final String INFORM_ABOUT_EQUAL_KANA_AND_KANJI = "options.informAboutEqualKanaAndKanjiAtStartup";
    private static final String SHOW_KANA = "options.showKanaWhenTestingVocable";
    private static final String CHECK_NEW_LISTS = "options.checkNewOwnListsVersionAtStart";
    private static final String KANA_IN_KANJI_SIZE_WHEN_TESTING = "options.showKanaInKanjiSizeWhenTestingVocable";
    private static final String EMTPY_TRANSLATION_ACCEPTANCE = "options.emptyTranslationsAcceptance";
    private static final String NUMBER_OF_DAYS_FOR_A_WHILE = "options.numberOfDaysForAWhile";
    private static final String NUMBER_OF_DAYS_A_VOCABLE_IS_NEW = "options.numberOfDaysAVocableIsNew";
    private static final String COLORS = "options.colors";
    private static final String DELTA_FOREGROUND = "options.deltaForForegroundColor";
    private static final String DELTA_BACKGROUND = "options.deltaForBackgroundColor";
    private static final String COLOR_MODIFICATION_TYPE = "options.colorModificationType";
    private static final String USE_SPLIT_PANE_IN_OLE = "options.useSplitPaneInOwnListEditor";
    private static final String VOCABLE_COLOR_STANDARD = "options.vocableColorStandard";
    private static final String VOCABLE_COLOR_KANJI = "options.vocableColorKanji";
    private static final String VOCABLE_COLOR_KANA = "options.vocableColorKana";
    private static final String VOCABLE_COLOR_ROMAJI = "options.vocableColorRomaji";
    private static final String VOCABLE_COLOR_PRONUNCIATION = "options.vocableColorPronunciation";
    private static final String VOCABLE_COLOR_TRANSLATION = "options.vocableColorTranslation";
    private static final String VOCABLE_COLOR_COMMENT = "options.vocableColorComment";
    private static final String VOCABLE_COLOR_SEARCH_WORDS = "options.vocableColorSearchWords";
    private static final String VOCABLE_COLOR_PART_OF_SPEACH = "options.vocableColorPartOfSpeach";
    private static final String SHOW_STARTUP_TIMESTAMP = "options.showTimestampsInStartup";
    private static final String CREATE_MAP_D_TO_J_AT_STARTUP = "options.createGermanJapaneseTranslationAtStartup";
    private static final String LAST_USED_7ZIP_DIR = "options.lastUsed7ZipDirectory";
    private static final String LAST_SELECTED_KANJI_SET_TEXT = "options.lastSelectedKanjiSetTextInCombobox";
    private static final String INFORM_ABOUT_E_OR_U_IN_AUSSPRACHE = "options.informAboutEOrUInVocableFieldAusspracheAtStartup";
    private static final String NUMBER_OF_REMEMBERED_OWN_LISTS = "options.numberOfRememberedOwnLists";
    private static final String HISTORICAL_LEFT_OWN_LISTS_IN_LIST_COMMANDER = "options.historicalLeftOwnListsInListCommander";
    private static final String HISTORICAL_RIGHT_OWN_LISTS_IN_LIST_COMMANDER = "options.historicalRightOwnListsInListCommander";
    private static final String HISTORICAL_OWN_LISTS = "options.historicalOwnLists";
    private static final String SHOW_ALL_TRANSLATIONS = "options.showAllTranslations";
    private static final String NUMBER_OF_SHOWN_TRANSLATIONS = "options.numberOfShownTranslations";
    private static final String SHOW_NUMBER_OF_LISTS = "options.showNumberOfListsInLister";
    private static final String SHOW_BUTTONS_IN_EINZELDARSTELLUNG = "options.showDetailBottomButonsInEinzeldarstellungToo";
    private static final String SHOW_BUTTONS_IN_TRANSLATION_EVALUATION = "options.showDetailBottomButonsInTranslationEvaluationToo";
    private static final String PLAY_MP3_WHEN_TESTING = "options.playMP3WhenTestingVocables";
    private static final String COLOR_USER_INPUT_WHEN_TESTING_KANJI = "options.colorUserInputAtKanjiTestEvaluationDialog";
    private static final String VOCABLE_TRAINER_DIRECTORY_IN_HOME_DIR = ".JapaneseVocableTrainer";
    public static final String VOCABLE_TRAINER_DIRECTORY = FileHelper.getAndPerhapsCreateDirectoryAtHome(".JapaneseVocableTrainer");
    private static final String SESSION_BARE_FILENAME = "japanese_vocable_trainer.xml";
    public static final String SESSION_FILENAME = FileHelper.concatPathes(VOCABLE_TRAINER_DIRECTORY, "japanese_vocable_trainer.xml");
    private final Version vocabularyTrainerVersion;
    private final Options options;
    private final SessionManagerHelper helper;

    public SessionManager(Version version) {
        this(version, new Options(version));
    }

    public SessionManager(Version version, Options options) {
        this.vocabularyTrainerVersion = version;
        this.options = options;
        this.helper = new SessionManagerHelper(SESSION_FILENAME);
    }

    public Options load() {
        this.loadInternal();
        return this.options;
    }

    private void loadInternal() {
        Properties properties = this.helper.readProperties();
        if (null != properties) {
            this.loadOptions(properties);
            this.adjustHistoricalOwnListsInListCommander();
        }
    }

    private void loadOptions(Properties properties) {
        int n;
        String string;
        if (properties.containsKey(STRING_SELECTION_FONT_SIZE)) {
            string = properties.getProperty(STRING_SELECTION_FONT_SIZE);
            n = NumberString.parseIntIgnore(string, -1);
            this.options.setStringSelectionFontSize(n);
        }
        if (properties.containsKey(STRING_SELECTION_LABEL_FONT_SIZE)) {
            string = properties.getProperty(STRING_SELECTION_LABEL_FONT_SIZE);
            n = NumberString.parseIntIgnore(string, -1);
            this.options.setStringSelectionLabelFontSize(n);
        }
        if (properties.containsKey(LAST_USED_VERSION)) {
            string = properties.getProperty(LAST_USED_VERSION);
            Version version = Version.createFromSerializedString(string);
            this.options.setLastUsedVersion(version);
        }
        if (properties.containsKey(VOCABULARIES_PATH)) {
            string = properties.getProperty(VOCABULARIES_PATH);
            this.options.setVocabulariesPath(string);
        }
        if (properties.containsKey(SWITCH_TO_NEXT_VOCABLE)) {
            string = properties.getProperty(SWITCH_TO_NEXT_VOCABLE);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setSwitchToNextVocableAfterEntringTranslation(bl);
        }
        if (properties.containsKey(SHOW_ROMAJI)) {
            string = properties.getProperty(SHOW_ROMAJI);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowRomajiWhenTestingVocable(bl);
        }
        if (properties.containsKey(SHOW_PRONUNCIATION)) {
            string = properties.getProperty(SHOW_PRONUNCIATION);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowPronunciationWhenTestingVocable(bl);
        }
        if (properties.containsKey(SHOW_COMMENT)) {
            string = properties.getProperty(SHOW_COMMENT);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowCommentWhenTestingVocable(bl);
        }
        if (properties.containsKey(SHOW_VOCABULARY_DESCRIPTION)) {
            string = properties.getProperty(SHOW_VOCABULARY_DESCRIPTION);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowVocabularyDescriptionWhenTestingVocable(bl);
        }
        if (properties.containsKey(BACKGROUND_COLORING_TESTING)) {
            string = properties.getProperty(BACKGROUND_COLORING_TESTING);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setColorVocableDependingOnLastSuccessWhenTestingVocable(bl);
        }
        if (properties.containsKey(BACKGROUND_COLORING_VIEWING)) {
            string = properties.getProperty(BACKGROUND_COLORING_VIEWING);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setColorVocableDependingOnLastSuccessWhenViewingVocable(bl);
        }
        if (properties.containsKey(VOCABULARY_SORT_ORDER)) {
            string = properties.getProperty(VOCABULARY_SORT_ORDER);
            VocabularySortOrder vocabularySortOrder = VocabularySortOrder.determineByName(string);
            this.options.setVocabularySortOrder(vocabularySortOrder);
        }
        if (properties.containsKey(FOREGROUND_COLORING_VOCABULARY)) {
            string = properties.getProperty(FOREGROUND_COLORING_VOCABULARY);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setColorVocabularyDependingOnLastSuccess(bl);
        }
        if (properties.containsKey(VOCABLES_SHUFFLE_TYPE)) {
            string = properties.getProperty(VOCABLES_SHUFFLE_TYPE);
            VocablesShuffleType vocablesShuffleType = VocablesShuffleType.determineByName(string);
            this.options.setVocablesShuffleType(vocablesShuffleType);
        }
        if (properties.containsKey(VOCABLES_SUBSET_SELECTION_TYPE)) {
            string = properties.getProperty(VOCABLES_SUBSET_SELECTION_TYPE);
            VocablesSubsetSelectionType vocablesSubsetSelectionType = VocablesSubsetSelectionType.determineByName(string);
            this.options.setVocablesSubsetSelectionType(vocablesSubsetSelectionType);
        }
        if (properties.containsKey(REVERSE_SHUFFLED_VOCABLES)) {
            string = properties.getProperty(REVERSE_SHUFFLED_VOCABLES);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setReverseShuffledVocables(bl);
        }
        if (properties.containsKey(USE_VOCABLES_SHUFFLE_TYPE_FOR_LISTS)) {
            string = properties.getProperty(USE_VOCABLES_SHUFFLE_TYPE_FOR_LISTS);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setUseVocablesShuffleTypeForShowingListsAndSheetsToo(bl);
        }
        if (properties.containsKey(HIDE_START_OF_VOCABULARY)) {
            string = properties.getProperty(HIDE_START_OF_VOCABULARY);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setHideStartOfVocabularyDescription(bl);
        }
        if (properties.containsKey(USE_TEST_ORDER_FOR_VIEWING)) {
            string = properties.getProperty(USE_TEST_ORDER_FOR_VIEWING);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setUseTestOrderForViewingVocables(bl);
        }
        if (properties.containsKey(LAST_SHOWN_MAIN_TAB_INDEX)) {
            string = properties.getProperty(LAST_SHOWN_MAIN_TAB_INDEX);
            int n2 = NumberString.parseIntIgnore(string, -1);
            this.options.setLastShownMainTabIndex(n2);
        }
        if (properties.containsKey(LAST_SHOWN_VOCABULARY_CATEGORY_TAB_INDEX)) {
            string = properties.getProperty(LAST_SHOWN_VOCABULARY_CATEGORY_TAB_INDEX);
            int n3 = NumberString.parseIntIgnore(string, -1);
            this.options.setLastShownVocabularyCategoryTabIndex(n3);
        }
        if (properties.containsKey(LAST_SHOWN_OWN_LIST_CATEGORY_TAB_INDEX)) {
            string = properties.getProperty(LAST_SHOWN_OWN_LIST_CATEGORY_TAB_INDEX);
            int n4 = NumberString.parseIntIgnore(string, -1);
            this.options.setLastShownOwnListCategoryTabIndex(n4);
        }
        if (properties.containsKey(LAST_SHOWN_VOCABULARY_SUB_CATEGORY_TAB_INDEX)) {
            string = properties.getProperty(LAST_SHOWN_VOCABULARY_SUB_CATEGORY_TAB_INDEX);
            int n5 = NumberString.parseIntIgnore(string, -1);
            this.options.setLastShownVocabularySubCategoryTabIndex(n5);
        }
        if (properties.containsKey(LAST_SHOWN_OWN_LIST_SUB_CATEGORY_TAB_INDEX)) {
            string = properties.getProperty(LAST_SHOWN_OWN_LIST_SUB_CATEGORY_TAB_INDEX);
            int n6 = NumberString.parseIntIgnore(string, -1);
            this.options.setLastShownOwnListSubCategoryTabIndex(n6);
        }
        if (properties.containsKey(SHOW_SUCCESS_PERCENT_IN_VOCABULARY_BAR)) {
            string = properties.getProperty(SHOW_SUCCESS_PERCENT_IN_VOCABULARY_BAR);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowSuccessPercentInVocabularyBar(bl);
        }
        if (properties.containsKey(NUMBER_OF_VOCABULARY_BAR_COLUMNS)) {
            string = properties.getProperty(NUMBER_OF_VOCABULARY_BAR_COLUMNS);
            int n7 = NumberString.parseIntIgnore(string, -1);
            this.options.setNumberOfVocabularyBarColumns(n7);
        }
        if (properties.containsKey(LAST_USED_OWN_LIST_DIRECTORY)) {
            string = properties.getProperty(LAST_USED_OWN_LIST_DIRECTORY);
            this.options.setLastUsedOwnListImportExportDirectory(string);
        }
        if (properties.containsKey(NUMBER_OF_DATASETS_PER_PAGE_OLE)) {
            string = properties.getProperty(NUMBER_OF_DATASETS_PER_PAGE_OLE);
            int n8 = NumberString.parseIntIgnore(string, -1);
            this.options.setNumberOfDatasetsPerPageOfOwnListEditor(n8);
        }
        if (properties.containsKey(NUMBER_OF_COLUMNS_OLE)) {
            string = properties.getProperty(NUMBER_OF_COLUMNS_OLE);
            int n9 = NumberString.parseIntIgnore(string, -1);
            this.options.setNumberOfColumnsOfOwnListEditor(n9);
        }
        if (properties.containsKey(LOCATION_OF_OLE)) {
            string = properties.getProperty(LOCATION_OF_OLE);
            Point point = SwingSessionManagerHelper.createPointFromStorageString(string);
            this.options.setLocationOfOwnListEditor(point);
        }
        if (properties.containsKey(SIZE_OF_OLE)) {
            string = properties.getProperty(SIZE_OF_OLE);
            Dimension dimension = SwingSessionManagerHelper.createDimensionFromStorageString(string);
            this.options.setSizeOfOwnListEditor(dimension);
        }
        if (properties.containsKey(HIDE_VOCABLES_FROM_LIST_OLE)) {
            string = properties.getProperty(HIDE_VOCABLES_FROM_LIST_OLE);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setHideVocablesFromListInSearchAreaInOwnListEditor(bl);
        }
        if (properties.containsKey(ALLOW_MISSING_MP3)) {
            string = properties.getProperty(ALLOW_MISSING_MP3);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setAllowMissingMp3(bl);
        }
        if (properties.containsKey(REPORT_MISSING_MP3)) {
            string = properties.getProperty(REPORT_MISSING_MP3);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setReportMissingMp3(bl);
        }
        if (properties.containsKey(NUMBER_OF_COLUMNS_OF_BLATT)) {
            string = properties.getProperty(NUMBER_OF_COLUMNS_OF_BLATT);
            int n10 = NumberString.parseIntIgnore(string, -1);
            this.options.setNumberOfColumnsOfBlattDarstellung(n10);
        }
        if (properties.containsKey(INFORM_ABOUT_DOUBLE_MP3)) {
            string = properties.getProperty(INFORM_ABOUT_DOUBLE_MP3);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setInformAboutDoubleMp3AtStartup(bl);
        }
        if (properties.containsKey(ONLY_USE_FIRST_GERMAN_TERM_TESTING)) {
            string = properties.getProperty(ONLY_USE_FIRST_GERMAN_TERM_TESTING);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setUseOnlyFirstGermanTermWhenTestingVocableGermanToJapanese(bl);
        }
        if (properties.containsKey(TRANSLATION_DIRECTION)) {
            string = properties.getProperty(TRANSLATION_DIRECTION);
            TranslationDirection translationDirection = TranslationDirection.determineByName(string);
            this.options.setTranslationDirection(translationDirection);
        }
        if (properties.containsKey(SHOW_KANJI)) {
            string = properties.getProperty(SHOW_KANJI);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowKanjiWhenTestingVocable(bl);
        }
        if (properties.containsKey(HIDE_KANJI_IF_HIRAGANA)) {
            string = properties.getProperty(HIDE_KANJI_IF_HIRAGANA);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setHideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana(bl);
        }
        if (properties.containsKey(HIDE_ROMAJI_IF_HIRAGANA)) {
            string = properties.getProperty(HIDE_ROMAJI_IF_HIRAGANA);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setHideRomajiWhenTestingVocableAndKanaContainsOnlyHiragana(bl);
        }
        if (properties.containsKey(HIDE_PRONUNCIATION_IF_HIRAGANA)) {
            string = properties.getProperty(HIDE_PRONUNCIATION_IF_HIRAGANA);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setHidePronunciationWhenTestingVocableAndKanaContainsOnlyHiragana(bl);
        }
        if (properties.containsKey(SHOW_DETAILS_BUTTON_EINZELDARSTELLUNG)) {
            string = properties.getProperty(SHOW_DETAILS_BUTTON_EINZELDARSTELLUNG);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowDetailsButtonInEinzeldarstellung(bl);
        }
        if (properties.containsKey(SHOW_DETAILS_BUTTON_VOKABELBLATTDARSTELLUNG)) {
            string = properties.getProperty(SHOW_DETAILS_BUTTON_VOKABELBLATTDARSTELLUNG);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowDetailsButtonInVokabelblattDarstellung(bl);
        }
        if (properties.containsKey(HIDE_LESS_START_OF_VOCABULARY_DESCRIPTION_VHS)) {
            string = properties.getProperty(HIDE_LESS_START_OF_VOCABULARY_DESCRIPTION_VHS);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setHideLessStartOfVocabularyDescriptionForVhs(bl);
        }
        if (properties.containsKey(INFORM_ABOUT_EQUAL_KANA_AND_KANJI)) {
            string = properties.getProperty(INFORM_ABOUT_EQUAL_KANA_AND_KANJI);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setInformAboutEqualKanaAndKanjiAtStartup(bl);
        }
        if (properties.containsKey(SHOW_KANA)) {
            string = properties.getProperty(SHOW_KANA);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowKanaWhenTestingVocable(bl);
        }
        if (properties.containsKey(CHECK_NEW_LISTS)) {
            string = properties.getProperty(CHECK_NEW_LISTS);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setCheckNewOwnListsVersionAtStart(bl);
        }
        if (properties.containsKey(KANA_IN_KANJI_SIZE_WHEN_TESTING)) {
            string = properties.getProperty(KANA_IN_KANJI_SIZE_WHEN_TESTING);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowKanaInKanjiSizeWhenTestingVocable(bl);
        }
        if (properties.containsKey(EMTPY_TRANSLATION_ACCEPTANCE)) {
            string = properties.getProperty(EMTPY_TRANSLATION_ACCEPTANCE);
            EmptyTranslationsAcceptance emptyTranslationsAcceptance = EmptyTranslationsAcceptance.createFromPersistence(string);
            this.options.setEmptyTranslationsAcceptance(emptyTranslationsAcceptance);
        }
        if (properties.containsKey(NUMBER_OF_DAYS_FOR_A_WHILE)) {
            string = properties.getProperty(NUMBER_OF_DAYS_FOR_A_WHILE);
            int n11 = NumberString.parseIntIgnore(string, -1);
            this.options.setNumberOfDaysForAWhile(n11);
        }
        if (properties.containsKey(NUMBER_OF_DAYS_A_VOCABLE_IS_NEW)) {
            string = properties.getProperty(NUMBER_OF_DAYS_A_VOCABLE_IS_NEW);
            int n12 = NumberString.parseIntIgnore(string, -1);
            this.options.setNumberOfDaysAVocableIsNew(n12);
        }
        if (properties.containsKey(COLORS)) {
            string = properties.getProperty(COLORS);
            List<Color> list = SwingSessionManagerHelper.createColorsListFromStorageString(string);
            this.options.setColors(list);
        }
        if (properties.containsKey(DELTA_FOREGROUND)) {
            string = properties.getProperty(DELTA_FOREGROUND);
            int n13 = NumberString.parseIntIgnore(string, -1);
            this.options.setDeltaForForegroundColor(n13);
        }
        if (properties.containsKey(DELTA_BACKGROUND)) {
            string = properties.getProperty(DELTA_BACKGROUND);
            int n14 = NumberString.parseIntIgnore(string, -1);
            this.options.setDeltaForBackgroundColor(n14);
        }
        if (properties.containsKey(COLOR_MODIFICATION_TYPE)) {
            string = properties.getProperty(COLOR_MODIFICATION_TYPE);
            ColorModificationType colorModificationType = ColorModificationType.determineByName(string);
            this.options.setColorModificationType(colorModificationType);
        }
        if (properties.containsKey(USE_SPLIT_PANE_IN_OLE)) {
            string = properties.getProperty(USE_SPLIT_PANE_IN_OLE);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setUseSplitPaneInOwnListEditor(bl);
        }
        if (properties.containsKey(VOCABLE_COLOR_STANDARD)) {
            string = properties.getProperty(VOCABLE_COLOR_STANDARD);
            Color color = SwingSessionManagerHelper.createColorFromStorageString(string);
            this.options.setVocableColorStandard(color);
        }
        if (properties.containsKey(VOCABLE_COLOR_KANJI)) {
            string = properties.getProperty(VOCABLE_COLOR_KANJI);
            Color color = SwingSessionManagerHelper.createColorFromStorageString(string);
            this.options.setVocableColorKanji(color);
        }
        if (properties.containsKey(VOCABLE_COLOR_KANA)) {
            string = properties.getProperty(VOCABLE_COLOR_KANA);
            Color color = SwingSessionManagerHelper.createColorFromStorageString(string);
            this.options.setVocableColorKana(color);
        }
        if (properties.containsKey(VOCABLE_COLOR_ROMAJI)) {
            string = properties.getProperty(VOCABLE_COLOR_ROMAJI);
            Color color = SwingSessionManagerHelper.createColorFromStorageString(string);
            this.options.setVocableColorRomaji(color);
        }
        if (properties.containsKey(VOCABLE_COLOR_PRONUNCIATION)) {
            string = properties.getProperty(VOCABLE_COLOR_PRONUNCIATION);
            Color color = SwingSessionManagerHelper.createColorFromStorageString(string);
            this.options.setVocableColorPronunciation(color);
        }
        if (properties.containsKey(VOCABLE_COLOR_TRANSLATION)) {
            string = properties.getProperty(VOCABLE_COLOR_TRANSLATION);
            Color color = SwingSessionManagerHelper.createColorFromStorageString(string);
            this.options.setVocableColorTranslation(color);
        }
        if (properties.containsKey(VOCABLE_COLOR_COMMENT)) {
            string = properties.getProperty(VOCABLE_COLOR_COMMENT);
            Color color = SwingSessionManagerHelper.createColorFromStorageString(string);
            this.options.setVocableColorComment(color);
        }
        if (properties.containsKey(VOCABLE_COLOR_SEARCH_WORDS)) {
            string = properties.getProperty(VOCABLE_COLOR_SEARCH_WORDS);
            Color color = SwingSessionManagerHelper.createColorFromStorageString(string);
            this.options.setVocableColorSearchWords(color);
        }
        if (properties.containsKey(VOCABLE_COLOR_PART_OF_SPEACH)) {
            string = properties.getProperty(VOCABLE_COLOR_PART_OF_SPEACH);
            Color color = SwingSessionManagerHelper.createColorFromStorageString(string);
            this.options.setVocableColorPartOfSpeach(color);
        }
        if (properties.containsKey(SHOW_STARTUP_TIMESTAMP)) {
            string = properties.getProperty(SHOW_STARTUP_TIMESTAMP);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowTimestampsInStartup(bl);
        }
        if (properties.containsKey(CREATE_MAP_D_TO_J_AT_STARTUP)) {
            string = properties.getProperty(CREATE_MAP_D_TO_J_AT_STARTUP);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setCreateGermanJapaneseTranslationAtStartup(bl);
        }
        if (properties.containsKey(LAST_USED_7ZIP_DIR)) {
            string = properties.getProperty(LAST_USED_7ZIP_DIR);
            this.options.setLastUsed7ZipDirectory(string);
        }
        if (properties.containsKey(LAST_SELECTED_KANJI_SET_TEXT)) {
            string = properties.getProperty(LAST_SELECTED_KANJI_SET_TEXT);
            this.options.setLastSelectedKanjiSetTextInCombobox(string);
        }
        if (properties.containsKey(INFORM_ABOUT_E_OR_U_IN_AUSSPRACHE)) {
            string = properties.getProperty(INFORM_ABOUT_E_OR_U_IN_AUSSPRACHE);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setInformAboutEOrUInVocableFieldAusspracheAtStartup(bl);
        }
        if (properties.containsKey(NUMBER_OF_REMEMBERED_OWN_LISTS)) {
            string = properties.getProperty(NUMBER_OF_REMEMBERED_OWN_LISTS);
            int n15 = NumberString.parseIntIgnore(string, -1);
            this.options.setNumberOfRememberedOwnLists(n15);
        }
        if (properties.containsKey(HISTORICAL_LEFT_OWN_LISTS_IN_LIST_COMMANDER)) {
            string = properties.getProperty(HISTORICAL_LEFT_OWN_LISTS_IN_LIST_COMMANDER);
            this.options.setHistoricalLeftOwnListsInListCommander(HistoricalOwnListPersistanceDataList.createFromPersistanceString(string, 1000));
        }
        if (properties.containsKey(HISTORICAL_RIGHT_OWN_LISTS_IN_LIST_COMMANDER)) {
            string = properties.getProperty(HISTORICAL_RIGHT_OWN_LISTS_IN_LIST_COMMANDER);
            this.options.setHistoricalRightOwnListsInListCommander(HistoricalOwnListPersistanceDataList.createFromPersistanceString(string, 1000));
        }
        if (properties.containsKey(HISTORICAL_OWN_LISTS)) {
            string = properties.getProperty(HISTORICAL_OWN_LISTS);
            this.options.setHistoricalOwnLists(HistoricalOwnListPersistanceDataList.createFromPersistanceString(string, 1000));
        }
        if (properties.containsKey(SHOW_ALL_TRANSLATIONS)) {
            string = properties.getProperty(SHOW_ALL_TRANSLATIONS);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowAllTranslations(bl);
        }
        if (properties.containsKey(NUMBER_OF_SHOWN_TRANSLATIONS)) {
            string = properties.getProperty(NUMBER_OF_SHOWN_TRANSLATIONS);
            int n16 = NumberString.parseIntIgnore(string, -1);
            this.options.setNumberOfShownTranslations(n16);
        }
        if (properties.containsKey(SHOW_NUMBER_OF_LISTS)) {
            string = properties.getProperty(SHOW_NUMBER_OF_LISTS);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowNumberOfListsInLister(bl);
        }
        if (properties.containsKey(SHOW_BUTTONS_IN_EINZELDARSTELLUNG)) {
            string = properties.getProperty(SHOW_BUTTONS_IN_EINZELDARSTELLUNG);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowDetailBottomButonsInEinzeldarstellungToo(bl);
        }
        if (properties.containsKey(SHOW_BUTTONS_IN_TRANSLATION_EVALUATION)) {
            string = properties.getProperty(SHOW_BUTTONS_IN_TRANSLATION_EVALUATION);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setShowDetailBottomButonsInTranslationEvaluationToo(bl);
        }
        if (properties.containsKey(PLAY_MP3_WHEN_TESTING)) {
            string = properties.getProperty(PLAY_MP3_WHEN_TESTING);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setPlayMP3WhenTestingVocables(bl);
        }
        if (properties.containsKey(COLOR_USER_INPUT_WHEN_TESTING_KANJI)) {
            string = properties.getProperty(COLOR_USER_INPUT_WHEN_TESTING_KANJI);
            boolean bl = BooleanHandling.stringToBoolean(string);
            this.options.setColorUserInputAtKanjiTestEvaluationDialog(bl);
        }
    }

    private void adjustHistoricalOwnListsInListCommander() {
        int n = this.options.getNumberOfRememberedOwnLists();
        HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList = this.options.getHistoricalLeftOwnListsInListCommander();
        HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList2 = this.options.getHistoricalRightOwnListsInListCommander();
        HistoricalOwnListPersistanceDataList historicalOwnListPersistanceDataList3 = this.options.getHistoricalOwnLists();
        historicalOwnListPersistanceDataList.setNumberOfRememberedOwnLists(n);
        historicalOwnListPersistanceDataList2.setNumberOfRememberedOwnLists(n);
        historicalOwnListPersistanceDataList3.setNumberOfRememberedOwnLists(n);
    }

    public void save() {
        Properties properties = new Properties();
        this.saveOptions(properties);
        this.helper.writeProperties(properties);
    }

    private void saveOptions(Properties properties) {
        properties.setProperty(STRING_SELECTION_FONT_SIZE, Integer.toString(this.options.getStringSelectionFontSize()));
        properties.setProperty(STRING_SELECTION_LABEL_FONT_SIZE, Integer.toString(this.options.getStringSelectionLabelFontSize()));
        properties.setProperty(LAST_USED_VERSION, this.vocabularyTrainerVersion.toSerializedString());
        properties.setProperty(VOCABULARIES_PATH, this.options.getVocabulariesPath());
        properties.setProperty(SWITCH_TO_NEXT_VOCABLE, BooleanHandling.booleanToString(this.options.isSwitchToNextVocableAfterEntringTranslation()));
        properties.setProperty(SHOW_ROMAJI, BooleanHandling.booleanToString(this.options.isShowRomajiWhenTestingVocable()));
        properties.setProperty(SHOW_PRONUNCIATION, BooleanHandling.booleanToString(this.options.isShowPronunciationWhenTestingVocable()));
        properties.setProperty(SHOW_COMMENT, BooleanHandling.booleanToString(this.options.isShowCommentWhenTestingVocable()));
        properties.setProperty(SHOW_VOCABULARY_DESCRIPTION, BooleanHandling.booleanToString(this.options.isShowVocabularyDescriptionWhenTestingVocable()));
        properties.setProperty(BACKGROUND_COLORING_TESTING, BooleanHandling.booleanToString(this.options.isColorVocableDependingOnLastSuccessWhenTestingVocable()));
        properties.setProperty(BACKGROUND_COLORING_VIEWING, BooleanHandling.booleanToString(this.options.isColorVocableDependingOnLastSuccessWhenViewingVocable()));
        properties.setProperty(VOCABULARY_SORT_ORDER, this.options.getVocabularySortOrder().name());
        properties.setProperty(FOREGROUND_COLORING_VOCABULARY, BooleanHandling.booleanToString(this.options.isColorVocabularyDependingOnLastSuccess()));
        properties.setProperty(VOCABLES_SHUFFLE_TYPE, this.options.getVocablesShuffleType().name());
        properties.setProperty(VOCABLES_SUBSET_SELECTION_TYPE, this.options.getVocablesSubsetSelectionType().name());
        properties.setProperty(REVERSE_SHUFFLED_VOCABLES, BooleanHandling.booleanToString(this.options.isReverseShuffledVocables()));
        properties.setProperty(USE_VOCABLES_SHUFFLE_TYPE_FOR_LISTS, BooleanHandling.booleanToString(this.options.isUseVocablesShuffleTypeForShowingListsAndSheetsToo()));
        properties.setProperty(HIDE_START_OF_VOCABULARY, BooleanHandling.booleanToString(this.options.isHideStartOfVocabularyDescription()));
        properties.setProperty(USE_TEST_ORDER_FOR_VIEWING, BooleanHandling.booleanToString(this.options.isUseTestOrderForViewingVocables()));
        properties.setProperty(LAST_SHOWN_MAIN_TAB_INDEX, Integer.toString(this.options.getLastShownMainTabIndex()));
        properties.setProperty(LAST_SHOWN_VOCABULARY_CATEGORY_TAB_INDEX, Integer.toString(this.options.getLastShownVocabularyCategoryTabIndex()));
        properties.setProperty(LAST_SHOWN_OWN_LIST_CATEGORY_TAB_INDEX, Integer.toString(this.options.getLastShownOwnListCategoryTabIndex()));
        properties.setProperty(LAST_SHOWN_VOCABULARY_SUB_CATEGORY_TAB_INDEX, Integer.toString(this.options.getLastShownVocabularySubCategoryTabIndex()));
        properties.setProperty(LAST_SHOWN_OWN_LIST_SUB_CATEGORY_TAB_INDEX, Integer.toString(this.options.getLastShownOwnListSubCategoryTabIndex()));
        properties.setProperty(SHOW_SUCCESS_PERCENT_IN_VOCABULARY_BAR, BooleanHandling.booleanToString(this.options.isShowSuccessPercentInVocabularyBar()));
        properties.setProperty(NUMBER_OF_VOCABULARY_BAR_COLUMNS, Integer.toString(this.options.getNumberOfVocabularyBarColumns()));
        properties.setProperty(LAST_USED_OWN_LIST_DIRECTORY, this.options.getLastUsedOwnListImportExportDirectory());
        properties.setProperty(NUMBER_OF_DATASETS_PER_PAGE_OLE, Integer.toString(this.options.getNumberOfDatasetsPerPageOfOwnListEditor()));
        properties.setProperty(NUMBER_OF_COLUMNS_OLE, Integer.toString(this.options.getNumberOfColumnsOfOwnListEditor()));
        properties.setProperty(LOCATION_OF_OLE, SwingSessionManagerHelper.createPointStorageString(this.options.getLocationOfOwnListEditor()));
        properties.setProperty(SIZE_OF_OLE, SwingSessionManagerHelper.createDimensionStorageString(this.options.getSizeOfOwnListEditor()));
        properties.setProperty(HIDE_VOCABLES_FROM_LIST_OLE, BooleanHandling.booleanToString(this.options.isHideVocablesFromListInSearchAreaInOwnListEditor()));
        properties.setProperty(ALLOW_MISSING_MP3, BooleanHandling.booleanToString(this.options.isAllowMissingMp3()));
        properties.setProperty(REPORT_MISSING_MP3, BooleanHandling.booleanToString(this.options.isReportMissingMp3()));
        properties.setProperty(NUMBER_OF_COLUMNS_OF_BLATT, Integer.toString(this.options.getNumberOfColumnsOfBlattDarstellung()));
        properties.setProperty(INFORM_ABOUT_DOUBLE_MP3, BooleanHandling.booleanToString(this.options.isInformAboutDoubleMp3AtStartup()));
        properties.setProperty(ONLY_USE_FIRST_GERMAN_TERM_TESTING, BooleanHandling.booleanToString(this.options.isUseOnlyFirstGermanTermWhenTestingVocableGermanToJapanese()));
        properties.setProperty(TRANSLATION_DIRECTION, this.options.getTranslationDirection().name());
        properties.setProperty(SHOW_KANJI, BooleanHandling.booleanToString(this.options.isShowKanjiWhenTestingVocable()));
        properties.setProperty(HIDE_KANJI_IF_HIRAGANA, BooleanHandling.booleanToString(this.options.isHideKanjiWhenTestingVocableAndKanaContainsOnlyHiragana()));
        properties.setProperty(HIDE_ROMAJI_IF_HIRAGANA, BooleanHandling.booleanToString(this.options.isHideRomajiWhenTestingVocableAndKanaContainsOnlyHiragana()));
        properties.setProperty(HIDE_PRONUNCIATION_IF_HIRAGANA, BooleanHandling.booleanToString(this.options.isHidePronunciationWhenTestingVocableAndKanaContainsOnlyHiragana()));
        properties.setProperty(SHOW_DETAILS_BUTTON_EINZELDARSTELLUNG, BooleanHandling.booleanToString(this.options.isShowDetailsButtonInEinzeldarstellung()));
        properties.setProperty(SHOW_DETAILS_BUTTON_VOKABELBLATTDARSTELLUNG, BooleanHandling.booleanToString(this.options.isShowDetailsButtonInVokabelblattDarstellung()));
        properties.setProperty(HIDE_LESS_START_OF_VOCABULARY_DESCRIPTION_VHS, BooleanHandling.booleanToString(this.options.isHideLessStartOfVocabularyDescriptionForVhs()));
        properties.setProperty(INFORM_ABOUT_EQUAL_KANA_AND_KANJI, BooleanHandling.booleanToString(this.options.isInformAboutEqualKanaAndKanjiAtStartup()));
        properties.setProperty(SHOW_KANA, BooleanHandling.booleanToString(this.options.isShowKanaWhenTestingVocable()));
        properties.setProperty(CHECK_NEW_LISTS, BooleanHandling.booleanToString(this.options.isCheckNewOwnListsVersionAtStart()));
        properties.setProperty(KANA_IN_KANJI_SIZE_WHEN_TESTING, BooleanHandling.booleanToString(this.options.isShowKanaInKanjiSizeWhenTestingVocable()));
        properties.setProperty(EMTPY_TRANSLATION_ACCEPTANCE, this.options.getEmptyTranslationsAcceptance().toPersistence());
        properties.setProperty(NUMBER_OF_DAYS_FOR_A_WHILE, Integer.toString(this.options.getNumberOfDaysForAWhile()));
        properties.setProperty(NUMBER_OF_DAYS_A_VOCABLE_IS_NEW, Integer.toString(this.options.getNumberOfDaysAVocableIsNew()));
        properties.setProperty(COLORS, SwingSessionManagerHelper.createColorsStorageString(this.options.getColors()));
        properties.setProperty(DELTA_FOREGROUND, Integer.toString(this.options.getDeltaForForegroundColor()));
        properties.setProperty(DELTA_BACKGROUND, Integer.toString(this.options.getDeltaForBackgroundColor()));
        properties.setProperty(COLOR_MODIFICATION_TYPE, this.options.getColorModificationType().name());
        properties.setProperty(USE_SPLIT_PANE_IN_OLE, BooleanHandling.booleanToString(this.options.isUseSplitPaneInOwnListEditor()));
        properties.setProperty(VOCABLE_COLOR_STANDARD, SwingSessionManagerHelper.createColorStorageString(this.options.getVocableColorStandard()));
        properties.setProperty(VOCABLE_COLOR_KANJI, SwingSessionManagerHelper.createColorStorageString(this.options.getVocableColorKanji()));
        properties.setProperty(VOCABLE_COLOR_KANA, SwingSessionManagerHelper.createColorStorageString(this.options.getVocableColorKana()));
        properties.setProperty(VOCABLE_COLOR_ROMAJI, SwingSessionManagerHelper.createColorStorageString(this.options.getVocableColorRomaji()));
        properties.setProperty(VOCABLE_COLOR_PRONUNCIATION, SwingSessionManagerHelper.createColorStorageString(this.options.getVocableColorPronunciation()));
        properties.setProperty(VOCABLE_COLOR_TRANSLATION, SwingSessionManagerHelper.createColorStorageString(this.options.getVocableColorTranslation()));
        properties.setProperty(VOCABLE_COLOR_COMMENT, SwingSessionManagerHelper.createColorStorageString(this.options.getVocableColorComment()));
        properties.setProperty(VOCABLE_COLOR_SEARCH_WORDS, SwingSessionManagerHelper.createColorStorageString(this.options.getVocableColorSearchWords()));
        properties.setProperty(VOCABLE_COLOR_PART_OF_SPEACH, SwingSessionManagerHelper.createColorStorageString(this.options.getVocableColorPartOfSpeach()));
        properties.setProperty(SHOW_STARTUP_TIMESTAMP, BooleanHandling.booleanToString(this.options.isShowTimestampsInStartup()));
        properties.setProperty(CREATE_MAP_D_TO_J_AT_STARTUP, BooleanHandling.booleanToString(this.options.isCreateGermanJapaneseTranslationAtStartup()));
        properties.setProperty(LAST_USED_7ZIP_DIR, this.options.getLastUsed7ZipDirectory());
        properties.setProperty(LAST_SELECTED_KANJI_SET_TEXT, this.options.getLastSelectedKanjiSetTextInCombobox());
        properties.setProperty(INFORM_ABOUT_E_OR_U_IN_AUSSPRACHE, BooleanHandling.booleanToString(this.options.isInformAboutEOrUInVocableFieldAusspracheAtStartup()));
        properties.setProperty(NUMBER_OF_REMEMBERED_OWN_LISTS, Integer.toString(this.options.getNumberOfRememberedOwnLists()));
        properties.setProperty(HISTORICAL_LEFT_OWN_LISTS_IN_LIST_COMMANDER, this.options.getHistoricalLeftOwnListsInListCommander().toPersistanceString());
        properties.setProperty(HISTORICAL_RIGHT_OWN_LISTS_IN_LIST_COMMANDER, this.options.getHistoricalRightOwnListsInListCommander().toPersistanceString());
        properties.setProperty(HISTORICAL_OWN_LISTS, this.options.getHistoricalOwnLists().toPersistanceString());
        properties.setProperty(SHOW_ALL_TRANSLATIONS, BooleanHandling.booleanToString(this.options.isShowAllTranslations()));
        properties.setProperty(NUMBER_OF_SHOWN_TRANSLATIONS, Integer.toString(this.options.getNumberOfShownTranslations()));
        properties.setProperty(SHOW_NUMBER_OF_LISTS, BooleanHandling.booleanToString(this.options.isShowNumberOfListsInLister()));
        properties.setProperty(SHOW_BUTTONS_IN_EINZELDARSTELLUNG, BooleanHandling.booleanToString(this.options.isShowDetailBottomButonsInEinzeldarstellungToo()));
        properties.setProperty(SHOW_BUTTONS_IN_TRANSLATION_EVALUATION, BooleanHandling.booleanToString(this.options.isShowDetailBottomButonsInTranslationEvaluationToo()));
        properties.setProperty(PLAY_MP3_WHEN_TESTING, BooleanHandling.booleanToString(this.options.isPlayMP3WhenTestingVocables()));
        properties.setProperty(COLOR_USER_INPUT_WHEN_TESTING_KANJI, BooleanHandling.booleanToString(this.options.isColorUserInputAtKanjiTestEvaluationDialog()));
    }
}

