/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.grammar;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.vocabulary.japanese.data.Vocable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class AdjectiveSearchWords {
    public static final String I_ADJECTIVE_POSITIVE_PRESENCE = "Positive Gegenwart I-Adjektiv";
    public static final String NA_ADJECTIVE_POSITIVE_PRESENCE = "Positive Gegenwart Na-Adjektiv";
    public static final List<String> SORTED_I_ADJEKTIVE_SEARCH_WORDS = CollectionsHelper.buildListFrom("Positive Gegenwart I-Adjektiv", "Negative Gegenwart I-Adjektiv", "Positive Vergangenheit I-Adjektiv", "Negative Vergangenheit I-Adjektiv");
    public static final List<String> SORTED_NA_ADJEKTIVE_SEARCH_WORDS = CollectionsHelper.buildListFrom("Positive Gegenwart Na-Adjektiv", "Negative Gegenwart Na-Adjektiv", "Negative Vergangenheit Na-Adjektiv");
    private static final List<String> SORTED_ADJEKTIVE_SEARCH_WORDS = CollectionsHelper.joinLists(SORTED_I_ADJEKTIVE_SEARCH_WORDS, SORTED_NA_ADJEKTIVE_SEARCH_WORDS);

    public static void sortVocablesByAdjectiveForms(List<Vocable> list) {
        Collections.sort(list, new Comparator<Vocable>(){

            @Override
            public int compare(Vocable vocable, Vocable vocable2) {
                int n = AdjectiveSearchWords.determineLowestExistingAdjectiveFormIndex(vocable.getSearchWords());
                int n2 = AdjectiveSearchWords.determineLowestExistingAdjectiveFormIndex(vocable2.getSearchWords());
                if (n == -1) {
                    n = Integer.MAX_VALUE;
                }
                if (n2 == -1) {
                    n2 = Integer.MAX_VALUE;
                }
                return n - n2;
            }
        });
    }

    private static int determineLowestExistingAdjectiveFormIndex(List<String> list) {
        int n = Integer.MAX_VALUE;
        for (String string : list) {
            int n2 = SORTED_ADJEKTIVE_SEARCH_WORDS.indexOf(string);
            if (n2 == -1 || n2 >= n) continue;
            n = n2;
        }
        return n;
    }
}

