/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.sort;

import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.sort.KanjiRelevanceWeightingCalculator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KanjiListSorter {
    private final List<Kanji> kanjiList;
    private final String search;
    private Map<Kanji, Integer> relevanceWeighting;

    public KanjiListSorter(List<Kanji> list, String string) {
        this.kanjiList = list;
        this.search = string;
    }

    public void sort() {
        if (this.kanjiList.size() > 1 && !this.search.isBlank()) {
            this.reallySort();
        }
    }

    private void reallySort() {
        this.createRelevanceWeighting();
        this.sortByRelevanceWeighting();
    }

    private void createRelevanceWeighting() {
        this.relevanceWeighting = new HashMap<Kanji, Integer>();
        for (Kanji kanji : this.kanjiList) {
            int n = this.calculateRelevanceWeighting(kanji);
            this.relevanceWeighting.put(kanji, n);
        }
    }

    private int calculateRelevanceWeighting(Kanji kanji) {
        KanjiRelevanceWeightingCalculator kanjiRelevanceWeightingCalculator = new KanjiRelevanceWeightingCalculator(kanji, this.search);
        kanjiRelevanceWeightingCalculator.calculate();
        return kanjiRelevanceWeightingCalculator.getWeighting();
    }

    private void sortByRelevanceWeighting() {
        Collections.sort(this.kanjiList, new Comparator<Kanji>(){

            @Override
            public int compare(Kanji kanji, Kanji kanji2) {
                int n = KanjiListSorter.this.relevanceWeighting.get((Object)kanji);
                int n2 = KanjiListSorter.this.relevanceWeighting.get((Object)kanji2);
                return n - n2;
            }
        });
    }
}

