/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.logic.symbol.kanji.test;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.test.data.KanjiUserInputType;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.test.data.SingleUserInputKanjiCheckResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class KanjiTestChecker {
    private final Kanji kanji;
    private final String germanMeaning;
    private final String onLesung;
    private final String kunLesung;
    private final boolean germanMeaningCaseSensitivity;
    private final boolean onLesungCaseSensitivity;
    private final boolean kunLesungCaseSensitivity;
    private String errorDescription;
    private String memorandum;
    private boolean ok;
    private final List<KanjiUserInputType> wrongKanjiUserInputTypes;
    private SingleUserInputKanjiCheckResult result;

    public KanjiTestChecker(Kanji kanji, String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) {
        this.kanji = kanji;
        this.germanMeaning = string;
        this.onLesung = string2;
        this.kunLesung = string3;
        this.germanMeaningCaseSensitivity = bl;
        this.onLesungCaseSensitivity = bl2;
        this.kunLesungCaseSensitivity = bl3;
        this.wrongKanjiUserInputTypes = new ArrayList<KanjiUserInputType>();
    }

    public void check() {
        this.init();
        this.checkGermanMeaning();
        this.checkOnLesung();
        this.checkKunLesung();
        this.createCheckResult();
    }

    private void init() {
        this.ok = true;
        this.errorDescription = "";
        this.memorandum = "";
    }

    private void checkGermanMeaning() {
        String string = this.kanji.getGermanMeaning();
        List<String> list = Text.splitByKomma(string);
        CollectionsHelper.sortStringListByLengthDescanding(list);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.germanMeaning;
        for (String string3 : list) {
            String string4;
            String string5;
            int n = string2.indexOf(string3);
            if (n != -1) {
                arrayList.add(string3);
                string5 = string2.substring(0, n);
                string4 = string2.substring(n + string3.length());
                string2 = Text.concatenate(string5, string4);
                continue;
            }
            if (this.germanMeaningCaseSensitivity) continue;
            string5 = Text.toLowerCase(string3);
            string4 = Text.toLowerCase(string2);
            n = string4.indexOf(string5);
            if (n == -1) continue;
            arrayList.add(string3);
            String string6 = string2.substring(0, n);
            String string7 = string2.substring(n + string3.length());
            string2 = Text.concatenate(string6, string7);
        }
        if (!string2.isEmpty()) {
            List<String> list2 = Text.splitBy(string2, "[, ]+");
            CollectionsHelper.removeEmptyAndOnlyWhitespaceStringsFromList(list2);
            arrayList.addAll((Collection<String>)list2);
        }
        this.check(KanjiUserInputType.GERMAN_MEANING, "deutsche Bedeutung", arrayList, list, this.germanMeaningCaseSensitivity);
    }

    private void checkOnLesung() {
        this.check(KanjiUserInputType.ON_LESUNG, "ON-Lesung", this.onLesung, CollectionsHelper.copyList(this.kanji.getOnLesungen()), this.onLesungCaseSensitivity);
    }

    private void checkKunLesung() {
        this.check(KanjiUserInputType.KUN_LESUNG, "kun-Lesung", this.kunLesung, CollectionsHelper.copyList(this.kanji.getKunLesungen()), this.kunLesungCaseSensitivity);
    }

    private void check(KanjiUserInputType kanjiUserInputType, String string, String string2, List<String> list, boolean bl) {
        List<String> list2 = Text.splitBy(string2, "[, ]+");
        this.check(kanjiUserInputType, string, list2, list, bl);
    }

    private void check(KanjiUserInputType kanjiUserInputType, String string, List<String> list, List<String> list2, boolean bl) {
        block6: {
            int n = this.countCorrectPartsAndRemoveThemFromLists(string, list2, list, bl);
            int n2 = list.size();
            if (n2 > 0) {
                this.ok = false;
                for (String string2 : list) {
                    this.addToErrorDescription(string + ": Falsch eingegebener Wert '" + string2 + "'.\n");
                    this.addToErrorTypes(kanjiUserInputType);
                }
            }
            if (list2.size() <= 0) break block6;
            if (n == 0) {
                this.ok = false;
                for (String string2 : list2) {
                    this.addToErrorDescription(string + ": Fehlender Wert '" + string2 + "'.\n");
                    this.addToErrorTypes(kanjiUserInputType);
                }
            } else {
                for (String string2 : list2) {
                    this.addToMemorandum(string + ": Weiterer Wert '" + string2 + "'.\n");
                }
            }
        }
    }

    private int countCorrectPartsAndRemoveThemFromLists(String string, List<String> list, List<String> list2, boolean bl) {
        int n = 0;
        boolean bl2 = true;
        while (!list2.isEmpty() && !list.isEmpty() && bl2) {
            int n2;
            int n3 = list2.size();
            int n4 = list.size();
            block1: for (n2 = 0; n2 < list2.size(); ++n2) {
                String string2 = list2.get(n2);
                if (!bl) {
                    string2 = Text.toLowerCase(string2);
                }
                for (int i = 0; i < list.size(); ++i) {
                    String string3 = list.get(i);
                    if (!bl) {
                        string3 = Text.toLowerCase(string3);
                    }
                    boolean bl3 = string2.equals(string3);
                    boolean bl4 = Text.equalsIgnoringRoundOrSquareBrackets(string2, string3);
                    if (bl4 && !bl3) {
                        this.addToMemorandum(string + ": Abweichungen die Klammern betreffend: '" + string2 + "' <-> '" + string3 + "'\n");
                    }
                    if (!bl4 && !bl3) continue;
                    ++n;
                    list2.remove(n2);
                    list.remove(i);
                    continue block1;
                }
            }
            n2 = list2.size();
            int n5 = list.size();
            if (n3 != n2 || n4 != n5) continue;
            bl2 = false;
        }
        return n;
    }

    private void addToErrorDescription(String string) {
        this.errorDescription = this.addToText(this.errorDescription, string);
    }

    private void addToErrorTypes(KanjiUserInputType kanjiUserInputType) {
        if (!this.wrongKanjiUserInputTypes.contains((Object)kanjiUserInputType)) {
            this.wrongKanjiUserInputTypes.add(kanjiUserInputType);
        }
    }

    private void addToMemorandum(String string) {
        this.memorandum = this.addToText(this.memorandum, string);
    }

    private String addToText(String string, String string2) {
        if (string.isBlank()) {
            return string2;
        }
        return string + string2;
    }

    private void createCheckResult() {
        this.result = new SingleUserInputKanjiCheckResult(this.kanji);
        this.result.setOk(this.ok);
        this.result.setErrorDescription(this.errorDescription);
        this.result.setWrongKanjiUserInputTypes(this.wrongKanjiUserInputTypes);
        this.result.setMemorandum(this.memorandum);
    }

    public SingleUserInputKanjiCheckResult getResult() {
        return this.result;
    }
}

