/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.startup.logic;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.datetime.date.ImmutualDate;
import de.duehl.basics.datetime.time.watch.StopWatch;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.logic.ErrorHandler;
import de.duehl.basics.text.NumberString;
import de.duehl.basics.text.Text;
import de.duehl.swing.ui.text.TextViewer;
import de.duehl.vocabulary.japanese.common.data.InternalAdditionalVocableData;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.persistence.SessionManager;
import de.duehl.vocabulary.japanese.data.KanjiSet;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.io.AllKanjiSetsReader;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.internal.RealInternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.KeyToVocableMapCreator;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.RealInternalKanaDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.io.InternalKanaDataReader;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.io.InternalKanjiDataReader;
import de.duehl.vocabulary.japanese.logic.translation.GermanToJapaneseTranslation;
import de.duehl.vocabulary.japanese.logic.translation.JapaneseToGermanTranslation;
import de.duehl.vocabulary.japanese.logic.wrongtested.WrongTestedVocables;
import de.duehl.vocabulary.japanese.startup.logic.VocabularyAndSoundFileFinder;
import de.duehl.vocabulary.japanese.startup.ui.MessageAppender;
import de.duehl.vocabulary.japanese.startup.ui.SplashScreen;
import de.duehl.vocabulary.japanese.tools.VocabularyTools;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StartupLoader
implements MessageAppender {
    private static final String INTERNAL_VARIABLE_DATA_EXTENSION = ".ivd";
    public static final String INTERNAL_DATA_DIRECTORY = FileHelper.concatPathes(SessionManager.VOCABLE_TRAINER_DIRECTORY, "internal_vocabulary_data");
    private final VocabularyTrainerGui gui;
    private final Options options;
    private List<Vocabulary> vocabularies;
    private List<String> allKeysFromReadInternalData;
    private List<String> unusedKeysFromReadInternalData;
    private List<String> seenKeysFromVocables;
    private List<String> multipleCreatedKeysFromVocables;
    private Map<String, InternalAdditionalVocableData> key2InternalDataMap;
    private Map<Vocable, InternalAdditionalVocableData> vocable2InternalDataMap;
    private InternalDataRequester internalDataRequester;
    private String loadUpMessage;
    private int newInternalDataCreationCounter;
    private GermanToJapaneseTranslation germanToJapaneseTranslation;
    private JapaneseToGermanTranslation japaneseToGermanTranslation;
    private OwnLists ownLists;
    private WrongTestedVocables wrongTestedVocables;
    private InternalKanjiDataRequester internalKanjiDataRequester;
    private List<KanjiSet> kanjiSets;
    private RealInternalKanaDataRequester internalKanaDataRequester;
    private final SplashScreen splashScreen;
    private StopWatch watch;

    public StartupLoader(VocabularyTrainerGui vocabularyTrainerGui, Options options) {
        this.gui = vocabularyTrainerGui;
        this.options = options;
        this.splashScreen = new SplashScreen(vocabularyTrainerGui.getProgramImage());
    }

    public void load() {
        try {
            this.tryToLoad();
        }
        catch (Exception exception) {
            ErrorHandler errorHandler = this.gui.createErrorHandler();
            errorHandler.error("Fehler beim Startup: " + exception.getMessage(), exception);
            this.closeSplashScreen();
            this.gui.closeDialog();
        }
    }

    private void tryToLoad() {
        this.init();
        this.showSplashScreen();
        this.startup();
        this.closeSplashScreen();
    }

    private void init() {
        this.watch = new StopWatch();
    }

    private void showSplashScreen() {
        this.splashScreen.setVisible(true);
    }

    private void startup() {
        this.readVocabularies();
        this.readInternalVocableData();
        this.joinVocablesWithInternalData();
        this.createInternalDataRequester();
        this.storeDateOfOldestVocableInEachVocabulary();
        this.createJapaneseToGermanTranslation();
        this.createGermanToJapaneseTranslation();
        this.initOwnListsAndReadWrongTestedVocableLists();
        this.checkDoubleKaniji();
        this.loadInternalKanjiData();
        this.loadKanjiSets();
        this.loadInternalKanaData();
        this.checkDoubleTranslationAtSameVocabel();
        this.checkEOrUInVocableFieldAusspracheIfWanted();
    }

    private void readVocabularies() {
        this.appendMessage("Lese Vokabularien ...");
        VocabularyAndSoundFileFinder vocabularyAndSoundFileFinder = new VocabularyAndSoundFileFinder(this.options, this);
        vocabularyAndSoundFileFinder.find();
        this.vocabularies = vocabularyAndSoundFileFinder.getVocabularies();
        this.loadUpMessage = vocabularyAndSoundFileFinder.getLoadUpMessage();
    }

    @Override
    public void appendMessage(String string) {
        Object object;
        if (this.options.isShowTimestampsInStartup()) {
            if (string.isBlank()) {
                object = string;
            } else {
                String string2 = this.watch.getTime() + " - ";
                if (string.startsWith(" ")) {
                    int n = Text.findIndexOfFirstNonSpace(string);
                    if (n == -1) {
                        throw new RuntimeException("Kann nicht sein, die Nachricht beginnt mit einem Leerzeichen, ist nicht blank, aber ich finde nicht den Index des ersten nicht Leerzeichens.");
                    }
                    String string3 = string.substring(0, n);
                    String string4 = string.substring(n);
                    object = string3 + string2 + string4;
                } else {
                    object = string2 + string;
                }
            }
        } else {
            object = string;
        }
        this.splashScreen.appendMessage((String)object);
    }

    private void readInternalVocableData() {
        Object object;
        this.appendMessage("Lese interne benutzerabh\u00e4ngige Daten zu allen Vokabeln ...");
        FileHelper.createDirectoryIfNotExists(INTERNAL_DATA_DIRECTORY);
        List<String> list = FileHelper.findFilesInMainDirectoryNio2WithExtensions(INTERNAL_DATA_DIRECTORY, INTERNAL_VARIABLE_DATA_EXTENSION);
        this.appendMessage(NumberString.taupu(list.size()) + " interne Datens\u00e4tze gefunden.");
        this.appendMessage("Lese interne Datens\u00e4tze ein ...");
        ArrayList<InternalAdditionalVocableData> arrayList = new ArrayList<InternalAdditionalVocableData>();
        for (String object2 : list) {
            object = InternalAdditionalVocableData.load(object2);
            arrayList.add((InternalAdditionalVocableData)object);
        }
        this.appendMessage(NumberString.taupu(arrayList.size()) + " interne Datens\u00e4tze eingelesen.");
        this.key2InternalDataMap = new HashMap<String, InternalAdditionalVocableData>();
        this.allKeysFromReadInternalData = new ArrayList<String>();
        for (InternalAdditionalVocableData internalAdditionalVocableData : arrayList) {
            object = internalAdditionalVocableData.getKey();
            if (this.key2InternalDataMap.containsKey(object) || this.allKeysFromReadInternalData.contains(object)) {
                throw new RuntimeException("Der Schl\u00fcssel '" + (String)object + "' kommt mehrfach vor!");
            }
            this.key2InternalDataMap.put((String)object, internalAdditionalVocableData);
            this.allKeysFromReadInternalData.add((String)object);
        }
        this.appendMessage("Verzeichnis mit " + NumberString.taupu(this.key2InternalDataMap.size()) + " Verweisen von Schl\u00fcssel auf interne Datens\u00e4tze aufgebaut.");
    }

    private void joinVocablesWithInternalData() {
        this.appendMessage("Verbinde die Vokabeln mit den internen benutzerabh\u00e4ngigen Daten ...");
        this.vocable2InternalDataMap = new HashMap<Vocable, InternalAdditionalVocableData>();
        this.newInternalDataCreationCounter = 0;
        this.unusedKeysFromReadInternalData = new ArrayList<String>();
        this.unusedKeysFromReadInternalData.addAll(this.allKeysFromReadInternalData);
        this.seenKeysFromVocables = new ArrayList<String>();
        this.multipleCreatedKeysFromVocables = new ArrayList<String>();
        for (Vocabulary object : this.vocabularies) {
            for (Vocable vocable : object.getVocables()) {
                this.joinVocableInternalData(vocable);
            }
        }
        this.appendMessage("Verzeichnis mit " + NumberString.taupu(this.vocable2InternalDataMap.size()) + " Verweisen von Vokabeln auf interne Datens\u00e4tze aufgebaut.");
        this.appendMessage(NumberString.taupu(this.newInternalDataCreationCounter) + " neue interne Daten angelegt.");
        if (this.unusedKeysFromReadInternalData.isEmpty()) {
            this.appendMessage("Alle interne Daten wurden einer Vokabel zugeordnet.");
        } else {
            this.appendMessage("Es gibt " + NumberString.taupu(this.unusedKeysFromReadInternalData.size()) + " interne Daten, welcher keiner Vokabel zugeordnet wurden:");
            for (String string : this.unusedKeysFromReadInternalData) {
                this.appendMessage("    " + string);
            }
        }
        if (this.multipleCreatedKeysFromVocables.isEmpty()) {
            this.appendMessage("Alle Vokabeln erzeugen unterschiedliche Schl\u00fcssel.");
        } else {
            this.appendMessage("Es gibt " + NumberString.taupu(this.multipleCreatedKeysFromVocables.size()) + " Schl\u00fcssel, welche zu mehr als einer Vokabel geh\u00f6ren");
            for (String string : this.multipleCreatedKeysFromVocables) {
                this.appendMessage("    " + string);
            }
            System.err.println("Daher wird der Start abgebrochen.");
            System.exit(1);
        }
    }

    private void joinVocableInternalData(Vocable vocable) {
        InternalAdditionalVocableData internalAdditionalVocableData;
        String string = VocabularyTools.createVocableKey(vocable);
        this.unusedKeysFromReadInternalData.remove(string);
        if (this.seenKeysFromVocables.contains(string)) {
            if (!this.multipleCreatedKeysFromVocables.contains(string)) {
                this.multipleCreatedKeysFromVocables.add(string);
            }
        } else {
            this.seenKeysFromVocables.add(string);
        }
        if (this.key2InternalDataMap.containsKey(string)) {
            internalAdditionalVocableData = this.key2InternalDataMap.get(string);
        } else {
            internalAdditionalVocableData = new InternalAdditionalVocableData();
            internalAdditionalVocableData.setKey(string);
            String string2 = FileHelper.concatPathes(INTERNAL_DATA_DIRECTORY, string + INTERNAL_VARIABLE_DATA_EXTENSION);
            internalAdditionalVocableData.setFilename(string2);
            internalAdditionalVocableData.setFirstSeenDate(new ImmutualDate());
            this.appendMessage("neu: " + string2);
            ++this.newInternalDataCreationCounter;
            internalAdditionalVocableData.save();
        }
        this.vocable2InternalDataMap.put(vocable, internalAdditionalVocableData);
    }

    private void createInternalDataRequester() {
        this.internalDataRequester = new RealInternalDataRequester(this.vocable2InternalDataMap);
    }

    private void storeDateOfOldestVocableInEachVocabulary() {
        this.appendMessage("Trage Datum der \u00e4ltesten Vokabel in allen Vokabularien ein ...");
        for (Vocabulary vocabulary : this.vocabularies) {
            this.storeDateOfOldestVocableInVocabulary(vocabulary);
        }
    }

    private void storeDateOfOldestVocableInVocabulary(Vocabulary vocabulary) {
        ImmutualDate immutualDate = new ImmutualDate();
        for (Vocable vocable : vocabulary.getVocables()) {
            InternalAdditionalVocableData internalAdditionalVocableData = this.vocable2InternalDataMap.get(vocable);
            ImmutualDate immutualDate2 = internalAdditionalVocableData.getFirstSeenDate();
            if (immutualDate2.equals(InternalAdditionalVocableData.NOT_SEEN_DATE) || !immutualDate2.before(immutualDate)) continue;
            immutualDate = immutualDate2;
        }
        vocabulary.setFirstSeenDate(immutualDate);
    }

    private void createJapaneseToGermanTranslation() {
        this.appendMessage("Erzeuge Datenstrukturen f\u00fcr die Zuordnung von Kana und Kanji zu Vokabeln sowie mehrdeutige Zuordnungen von Kana ohne Kanji zu Vokabeln f\u00fcr die \u00dcbersetzung von Japanisch in Deutsch ...");
        this.japaneseToGermanTranslation = new JapaneseToGermanTranslation(this.vocabularies);
    }

    private void createGermanToJapaneseTranslation() {
        if (this.options.isCreateGermanJapaneseTranslationAtStartup()) {
            this.appendMessage("Erzeuge Datenstrukturen f\u00fcr mehrdeutige \u00dcbersetzungen von Deutsch in Japanisch ...");
            this.germanToJapaneseTranslation = new GermanToJapaneseTranslation(this.vocabularies);
        } else {
            this.appendMessage("Die Datenstrukturen f\u00fcr mehrdeutige \u00dcbersetzungen von Deutsch in Japanisch werden noch nicht erzeugt, sondern erst bei der ersten Verwendung.");
        }
    }

    private void initOwnListsAndReadWrongTestedVocableLists() {
        this.appendMessage("Erzeuge Verzeichnis Schl\u00fcssel zu Vokabel ...");
        KeyToVocableMapCreator keyToVocableMapCreator = new KeyToVocableMapCreator(this.vocabularies, this.internalDataRequester);
        keyToVocableMapCreator.create();
        Map<String, Vocable> map = keyToVocableMapCreator.getKeyToVocable();
        this.appendMessage("Erzeuge Verwaltung der eigene Listen ...");
        this.ownLists = new OwnLists(this.vocabularies, map, this.internalDataRequester, this.options, this.gui);
        this.appendMessage("Erzeuge Verwaltung der automatisch gepflegten Listen der falsch \u00fcbersetzten Vokabeln ...");
        this.wrongTestedVocables = new WrongTestedVocables(this.vocabularies, map, this.internalDataRequester);
    }

    private void checkDoubleKaniji() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Kanji kanji : Kanji.getAllKanjiAsList()) {
            String string = kanji.getCharacter();
            if (arrayList.contains(string)) {
                this.reportAboutFatalErrorsAndExit("Zum Kanji '" + string + "' sind mehr als ein Enum-Element in der Klasse Kanji hinterlegt.");
            }
            arrayList.add(string);
        }
    }

    private void loadInternalKanjiData() {
        InternalKanjiDataReader internalKanjiDataReader = new InternalKanjiDataReader(this);
        internalKanjiDataReader.read();
        this.internalKanjiDataRequester = internalKanjiDataReader.getRequester();
    }

    private void loadKanjiSets() {
        this.appendMessage("Lade die benutzerdefinierten Kanji-Mengen ...");
        this.kanjiSets = AllKanjiSetsReader.read();
    }

    private void loadInternalKanaData() {
        InternalKanaDataReader internalKanaDataReader = new InternalKanaDataReader(this);
        internalKanaDataReader.read();
        this.internalKanaDataRequester = internalKanaDataReader.getRequester();
    }

    private void checkDoubleTranslationAtSameVocabel() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                String string = this.checkDoubleTranslationAtSameVocabel(vocable);
                if (string.isBlank()) continue;
                arrayList.add(string + " (im Vokabular '" + vocabulary.getDescription() + "').");
            }
        }
        if (!arrayList.isEmpty()) {
            this.reportAboutFatalErrorsAndExit(Text.joinWithLineBreak(arrayList));
        }
    }

    private String checkDoubleTranslationAtSameVocabel(Vocable vocable) {
        List<String> list = CollectionsHelper.getNotDisjunktTexts(vocable.getTranslations());
        if (list.isEmpty()) {
            return "";
        }
        return "Zur Vokabel '" + vocable.getKanjiKanaRomajiWithJapaneseBraces() + "' gibt es mehrfach vorkommende \u00dcbersetzungen: '" + Text.join("', '", list) + "'";
    }

    private void checkEOrUInVocableFieldAusspracheIfWanted() {
        if (this.options.isInformAboutEOrUInVocableFieldAusspracheAtStartup()) {
            this.checkEOrUInVocableFieldAussprache();
        }
    }

    private void checkEOrUInVocableFieldAussprache() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                String string = vocable.getPronunciation();
                if (!string.contains("e") && !string.contains("u")) continue;
                String string2 = "Die Vokabel '" + vocable.getKanjiKanaRomajiWithJapaneseBraces() + "' (im Vokabular '" + vocabulary.getDescription() + "' enth\u00e4lt 'e' oder 'u' in ihrer Aussprache: '" + string + "'.";
                arrayList.add(string2);
            }
        }
        if (!arrayList.isEmpty()) {
            this.reportAboutFatalErrorsAndExit(Text.joinWithLineBreak(arrayList));
        }
    }

    private void closeSplashScreen() {
        this.splashScreen.closeDialog();
    }

    private void reportAboutFatalErrorsAndExit(String string) {
        String string2 = "Es ist ein Fehler aufgetreten, der den Start verhindert:\n" + string;
        this.splashScreen.appendMessage(string2);
        this.closeSplashScreen();
        System.err.println(string2);
        this.showFatalErrorMessagesAsDialog(string2);
        System.exit(1);
    }

    private void showFatalErrorMessagesAsDialog(String string) {
        TextViewer textViewer = new TextViewer("Fatale Fehlermedlung");
        textViewer.setText(string);
        textViewer.setVisible(true);
    }

    public String getLoadUpMessage() {
        return this.loadUpMessage;
    }

    public List<Vocabulary> getVocabularies() {
        return this.vocabularies;
    }

    public InternalDataRequester getInternalDataRequester() {
        return this.internalDataRequester;
    }

    public JapaneseToGermanTranslation getJapaneseToGermanTranslation() {
        return this.japaneseToGermanTranslation;
    }

    public GermanToJapaneseTranslation getGermanToJapaneseTranslation() {
        return this.germanToJapaneseTranslation;
    }

    public OwnLists getOwnLists() {
        return this.ownLists;
    }

    public WrongTestedVocables getWrongTestedVocables() {
        return this.wrongTestedVocables;
    }

    public InternalKanjiDataRequester getInternalKanjiDataRequester() {
        return this.internalKanjiDataRequester;
    }

    public List<KanjiSet> getKanjiSets() {
        return this.kanjiSets;
    }

    public RealInternalKanaDataRequester getInternalKanaDataRequester() {
        return this.internalKanaDataRequester;
    }

    public String getStartUpLog() {
        return this.splashScreen.getSplashText();
    }
}

