/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components.bars;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.move.SwitchableVerticalMoveButtons;
import de.duehl.swing.ui.move.data.MovingGui;
import de.duehl.swing.ui.move.data.NotMovingGui;
import de.duehl.swing.ui.move.data.VerticalMoveButtonsUser;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.components.text.VocaleBarTextCreator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class VocableBar
implements VerticalMoveButtonsUser {
    private final Vocable vocable;
    private final Runnable buttonAction;
    private final MovingGui<Vocable> gui;
    private final JPanel panel;
    private final JPanel rightPanel;
    private final JLabel vocableLabel;
    private final JCheckBox selectionCheckBox;
    private final JButton multifunctionButton;
    private final SwitchableVerticalMoveButtons switchableMoveButtons;
    private boolean canBeMoved;
    private boolean showExtraDetailButtonOnTheLeft;
    private final JButton extraDetailbutton;

    public VocableBar(Vocable vocable, Runnable runnable) {
        this(vocable, runnable, new NotMovingGui<Vocable>());
    }

    public VocableBar(Vocable vocable, Runnable runnable, MovingGui<Vocable> movingGui) {
        this.vocable = vocable;
        this.buttonAction = runnable;
        this.gui = movingGui;
        this.panel = new JPanel();
        this.vocableLabel = new JLabel();
        this.rightPanel = new JPanel();
        this.multifunctionButton = new JButton();
        this.selectionCheckBox = new JCheckBox();
        this.switchableMoveButtons = new SwitchableVerticalMoveButtons(this);
        this.showExtraDetailButtonOnTheLeft = false;
        this.extraDetailbutton = new JButton("?");
        this.init();
    }

    private void init() {
        this.initVocableLabel();
        this.initButton();
        this.initRightPanel();
    }

    private void initVocableLabel() {
        this.vocableLabel.setText(this.createVocableText());
        GuiTools.biggerFont(this.vocableLabel, 7);
        this.vocableLabel.setHorizontalAlignment(0);
    }

    private void initButton() {
        this.multifunctionButton.addActionListener(actionEvent -> this.buttonAction.run());
    }

    private void initRightPanel() {
        this.rightPanel.setLayout(new BorderLayout());
        this.rightPanel.add((Component)this.multifunctionButton, "East");
    }

    public void useButtonAsAddVocableToList() {
        this.multifunctionButton.setText("hinzuf\u00fcgen");
        this.rightPanel.add((Component)this.selectionCheckBox, "West");
        this.canBeMoved = true;
    }

    public void useButtonAsDeletion() {
        this.multifunctionButton.setText("entfernen");
        this.canBeMoved = true;
    }

    public void useButtonAsShowDetails() {
        this.multifunctionButton.setText("Details ansehen");
        this.canBeMoved = false;
    }

    public void showExtraDetailButtonOnTheLeft(Runnable runnable) {
        this.extraDetailbutton.addActionListener(actionEvent -> runnable.run());
        this.showExtraDetailButtonOnTheLeft = true;
    }

    public void createGui() {
        this.setUpAndDownButtonColorsAndEnabled();
        this.fillPanel();
    }

    public void disable() {
        this.multifunctionButton.setEnabled(false);
        this.selectionCheckBox.setSelected(false);
        this.selectionCheckBox.setEnabled(false);
        this.vocableLabel.setForeground(Color.LIGHT_GRAY);
        this.extraDetailbutton.setEnabled(false);
    }

    public void enable() {
        this.multifunctionButton.setEnabled(true);
        this.selectionCheckBox.setEnabled(true);
        this.vocableLabel.setForeground(Color.BLACK);
        this.extraDetailbutton.setEnabled(true);
    }

    @Override
    public boolean canMoveButtonsUserMoveUp() {
        return this.canBeMoved && this.gui.canBarMoveUp(this.vocable);
    }

    @Override
    public boolean canMoveButtonsUserMoveDown() {
        return this.canBeMoved && this.gui.canBarMoveDown(this.vocable);
    }

    @Override
    public void moveMoveButtonsUserToFirst() {
        if (this.canBeMoved) {
            this.gui.moveBarToFirst(this.vocable);
        }
    }

    @Override
    public void moveMoveButtonsUserUp() {
        if (this.canBeMoved) {
            this.gui.moveBarUp(this.vocable);
        }
    }

    @Override
    public void moveMoveButtonsUserDown() {
        if (this.canBeMoved) {
            this.gui.moveBarDown(this.vocable);
        }
    }

    @Override
    public void moveMoveButtonsUserToLast() {
        if (this.canBeMoved) {
            this.gui.moveBarToLast(this.vocable);
        }
    }

    public void setUpAndDownButtonColorsAndEnabled() {
        this.switchableMoveButtons.setUpAndDownButtonColorsAndEnabled();
    }

    private void fillPanel() {
        this.panel.setLayout(new BorderLayout());
        GuiTools.createTitle(this.panel);
        if (this.showExtraDetailButtonOnTheLeft) {
            this.panel.add((Component)GuiTools.centerVertical(this.extraDetailbutton), "West");
        }
        this.panel.add((Component)this.vocableLabel, "Center");
        this.panel.add(this.createButtonPart(), "East");
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.rightPanel, "West");
        jPanel.add((Component)GuiTools.centerVertical(this.switchableMoveButtons.getPanel()), "East");
        return jPanel;
    }

    private String createVocableText() {
        VocaleBarTextCreator vocaleBarTextCreator = new VocaleBarTextCreator(this.vocable);
        vocaleBarTextCreator.create();
        return vocaleBarTextCreator.getText();
    }

    public Component getPanel() {
        return this.panel;
    }

    public void setSelected(boolean bl) {
        this.selectionCheckBox.setSelected(bl);
    }

    public boolean isSelected() {
        return this.selectionCheckBox.isSelected();
    }

    public void showMoveButtonsOnBars(boolean bl) {
        this.switchableMoveButtons.showMoveButtons(bl);
        this.panel.repaint();
    }
}

