/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.components.display;

import de.duehl.swing.ui.GuiTools;
import de.duehl.vocabulary.japanese.common.persistence.KanjiAndKanaColorOptions;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.ui.components.text.KanjiAndKanaTextCreator;
import java.awt.Color;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class KanjiAndKanaDisplay {
    private static final int FONT_SIZE_BASE = 28;
    private final Vocable vocable;
    private final JTextPane kanjiAndKanaPane;
    private final Color backgroundColor;
    private final KanjiAndKanaColorOptions options;
    private boolean showKana;
    private boolean showKanji;
    private Style regularStyle;
    private Style kanjiStyle;
    private Style kanaStyle;
    private Style braceStyle;
    private boolean showKanaInKanjiSize;

    public KanjiAndKanaDisplay(Vocable vocable, JTextPane jTextPane, Color color, KanjiAndKanaColorOptions kanjiAndKanaColorOptions) {
        this.vocable = vocable;
        this.kanjiAndKanaPane = jTextPane;
        this.backgroundColor = color;
        this.options = kanjiAndKanaColorOptions;
        this.showKana = true;
        this.showKanji = true;
        this.showKanaInKanjiSize = false;
    }

    public void hideKana() {
        this.showKana = false;
    }

    public void hideKanji() {
        this.showKanji = false;
    }

    public void showKanaInKanjiSize() {
        this.showKanaInKanjiSize = true;
    }

    public void display() {
        this.initTextPane();
        this.createStyles();
        this.clearContent();
        this.fillWithNewText();
    }

    private void initTextPane() {
        this.kanjiAndKanaPane.setEditable(false);
        GuiTools.respectTextPaneBackgroundInNimbusLookAndFeel(this.kanjiAndKanaPane);
        this.kanjiAndKanaPane.setBackground(this.backgroundColor);
    }

    private void createStyles() {
        StyledDocument styledDocument = this.kanjiAndKanaPane.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        this.regularStyle = styledDocument.addStyle("regular", style);
        StyleConstants.setForeground(this.regularStyle, this.options.getVocableColorStandard());
        StyleConstants.setBackground(this.regularStyle, this.backgroundColor);
        StyleConstants.setFontSize(this.regularStyle, 28);
        StyleConstants.setSpaceAbove(this.regularStyle, 1.0f);
        StyleConstants.setSpaceBelow(this.regularStyle, 1.0f);
        StyleConstants.setLeftIndent(this.regularStyle, 16.0f);
        StyleConstants.setRightIndent(this.regularStyle, 16.0f);
        StyleConstants.setFirstLineIndent(this.regularStyle, 16.0f);
        StyleConstants.setFontFamily(this.regularStyle, "serif");
        StyleConstants.setAlignment(this.regularStyle, 0);
        this.kanjiStyle = styledDocument.addStyle("kanji", this.regularStyle);
        StyleConstants.setForeground(this.kanjiStyle, this.options.getVocableColorKanji());
        StyleConstants.setBackground(this.kanjiStyle, this.backgroundColor);
        StyleConstants.setFontSize(this.kanjiStyle, 32);
        StyleConstants.setBold(this.kanjiStyle, true);
        this.kanaStyle = styledDocument.addStyle("kana", this.regularStyle);
        StyleConstants.setForeground(this.kanaStyle, this.options.getVocableColorKana());
        StyleConstants.setBackground(this.kanaStyle, this.backgroundColor);
        if (this.showKanaInKanjiSize) {
            StyleConstants.setFontSize(this.kanaStyle, 32);
            StyleConstants.setBold(this.kanaStyle, true);
        }
        this.braceStyle = styledDocument.addStyle("brace", this.regularStyle);
        if (this.showKanaInKanjiSize) {
            StyleConstants.setFontSize(this.braceStyle, 32);
        }
    }

    private void clearContent() {
        try {
            StyledDocument styledDocument = this.kanjiAndKanaPane.getStyledDocument();
            styledDocument.remove(0, styledDocument.getLength());
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Probleme beim L\u00f6schen des Inhaltes des Dokument.", badLocationException);
        }
    }

    private void fillWithNewText() {
        try {
            this.tryToFillWithNewText();
        }
        catch (BadLocationException badLocationException) {
            throw new RuntimeException("Probleme beim Einf\u00fcgen eines Stils ins Dokument.", badLocationException);
        }
    }

    private void tryToFillWithNewText() throws BadLocationException {
        KanjiAndKanaTextCreator kanjiAndKanaTextCreator = new KanjiAndKanaTextCreator(this.vocable, this.showKana, this.showKanji);
        kanjiAndKanaTextCreator.create();
        String string = kanjiAndKanaTextCreator.getFirstTextPart();
        String string2 = kanjiAndKanaTextCreator.getTextPartInBrace();
        boolean bl = kanjiAndKanaTextCreator.isBraceInOwnLine();
        StyledDocument styledDocument = this.kanjiAndKanaPane.getStyledDocument();
        styledDocument.insertString(styledDocument.getLength(), string, this.kanjiStyle);
        if (bl) {
            styledDocument.insertString(styledDocument.getLength(), "\n", this.regularStyle);
        }
        if (!string2.isBlank()) {
            styledDocument.insertString(styledDocument.getLength(), " (", this.braceStyle);
            styledDocument.insertString(styledDocument.getLength(), string2, this.kanaStyle);
            styledDocument.insertString(styledDocument.getLength(), ")", this.braceStyle);
        }
    }
}

