/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.creation.menu;

import de.duehl.swing.ui.menu.MyMenuItem;
import de.duehl.swing.ui.menu.SingleMenuCreation;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class OwnListMenuCreation
implements SingleMenuCreation {
    private final VocabularyTrainerGui gui;

    public OwnListMenuCreation(VocabularyTrainerGui vocabularyTrainerGui) {
        this.gui = vocabularyTrainerGui;
    }

    @Override
    public JMenu createTheMenu() {
        JMenu jMenu = new JMenu("Eigene Listen");
        jMenu.setMnemonic('l');
        jMenu.add(this.createCreateNewOwnListMenuItem());
        jMenu.add(this.createToggleShowOwnListButtonsMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createImportOwnListsMenuItem());
        jMenu.add(this.createExportOwnListsMenuItem());
        jMenu.add(this.createExportAllOwnListsMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createListCommanderMenuItem());
        jMenu.addSeparator();
        jMenu.add(this.createImportOwnListsGroupsFromWebsiteMenuItem());
        return jMenu;
    }

    private JMenuItem createCreateNewOwnListMenuItem() {
        return new MyMenuItem("Eine neue eigene Liste anlegen").mnemonic('b').accelerator(115, 0).actionListener(actionEvent -> this.gui.createNewOwnList());
    }

    private JMenuItem createToggleShowOwnListButtonsMenuItem() {
        return new MyMenuItem("Buttons zum Exportieren, Bearbeiten und L\u00f6schen von eigene Listen ein oder ausschalten").mnemonic('e').accelerator(114, 0).actionListener(actionEvent -> this.gui.toggleShowOwnListButtons());
    }

    private JMenuItem createImportOwnListsMenuItem() {
        return new MyMenuItem("Eigene Vokabellisten importieren ...").mnemonic('i').actionListener(actionEvent -> this.gui.importOwnList());
    }

    private JMenuItem createExportOwnListsMenuItem() {
        return new MyMenuItem("Eigene Vokabellisten exportieren ...").mnemonic('x').actionListener(actionEvent -> this.gui.exportOwnLists());
    }

    private JMenuItem createExportAllOwnListsMenuItem() {
        return new MyMenuItem("Alle eigenen Vokabellisten exportieren ...").mnemonic('a').actionListener(actionEvent -> this.gui.exportAllOwnLists());
    }

    private JMenuItem createListCommanderMenuItem() {
        return new MyMenuItem("Listen-Commander \u00f6ffnen ...").mnemonic('c').accelerator(118, 128).actionListener(actionEvent -> this.gui.openListCommander());
    }

    private JMenuItem createImportOwnListsGroupsFromWebsiteMenuItem() {
        return new MyMenuItem("Gruppen von eigenen Vokabellisten von der Webseite importieren ...").mnemonic('i').actionListener(actionEvent -> this.gui.importGroupsOfOwnListsFromWebsite());
    }
}

