/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.logic.LongTimeProcessInformer;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.NonModalFrameDialogBase;
import de.duehl.swing.ui.tables.ButtonColumn;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.Vocabulary;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import de.duehl.vocabulary.japanese.ui.data.MessageSetter;
import de.duehl.vocabulary.japanese.ui.dialog.VocabularyListerDialog;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.components.KanjiDetailDialog;
import de.duehl.vocabulary.japanese.ui.dialog.table.kanji.KanjiTableColumnModel;
import de.duehl.vocabulary.japanese.ui.dialog.table.kanji.KanjiTableModel;
import de.duehl.vocabulary.japanese.ui.dialog.table.kanji.KanjiTableRenderer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableRowSorter;

public class KanjiTableDialog
extends NonModalFrameDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(1500, 1000);
    private static final Color TABLE_FOREGROUND = new Color(0, 0, 255);
    private static final Color TABLE_BACKGROUND = new Color(240, 240, 255);
    private static final float DEFAULT_FONT_SIZE = 15.0f;
    private final List<Kanji> kanjiList;
    private final Options options;
    private final InternalDataRequester requester;
    private final InternalKanjiDataRequester kanjiRequester;
    private final List<Vocabulary> vocabularies;
    private final LongTimeProcessInformer informer;
    private final OwnLists ownLists;
    private final MessageSetter messageSetter;
    private final JTable table;
    private final KanjiTableModel tableModel;
    private final KanjiTableRenderer tableRenderer;
    private JScrollPane scrollPane;
    private final JButton increaseFontSizeButton;
    private final JButton standardFontSizeButton;
    private final JButton decreaseFontSizeButton;

    public KanjiTableDialog(Options options, InternalDataRequester internalDataRequester, List<Vocabulary> list, InternalKanjiDataRequester internalKanjiDataRequester, LongTimeProcessInformer longTimeProcessInformer, OwnLists ownLists, MessageSetter messageSetter, Point point, Image image) {
        this(Kanji.getAllKanjiAsList(), options, internalDataRequester, list, internalKanjiDataRequester, longTimeProcessInformer, ownLists, KanjiTableDialog.createDialogTitle(Kanji.getNumberOfKnownKanji()), messageSetter, point, image);
    }

    public KanjiTableDialog(List<Kanji> list, Options options, InternalDataRequester internalDataRequester, List<Vocabulary> list2, InternalKanjiDataRequester internalKanjiDataRequester, LongTimeProcessInformer longTimeProcessInformer, OwnLists ownLists, String string, MessageSetter messageSetter, Point point, Image image) {
        super(point, image, string, DIALOG_DIMENSION);
        this.addEscapeBehaviour();
        this.kanjiList = list;
        this.options = options;
        this.requester = internalDataRequester;
        this.vocabularies = list2;
        this.informer = longTimeProcessInformer;
        this.kanjiRequester = internalKanjiDataRequester;
        this.ownLists = ownLists;
        this.messageSetter = messageSetter;
        this.table = new JTable();
        this.tableModel = new KanjiTableModel(options, list, internalKanjiDataRequester);
        this.tableRenderer = new KanjiTableRenderer(TABLE_FOREGROUND, TABLE_BACKGROUND);
        this.increaseFontSizeButton = new JButton();
        this.standardFontSizeButton = new JButton();
        this.decreaseFontSizeButton = new JButton();
        this.init();
        this.fillDialog();
    }

    private static String createDialogTitle(int n) {
        return "Liste mit den " + NumberString.taupu(n) + " bislang erfassten Kanji.";
    }

    private void init() {
        this.initTable();
        this.initScrollPane();
    }

    private void initTable() {
        this.initTableModel();
        this.initTableColumnModel();
        this.initTableRenderer();
        this.setTableSelectionMode();
        this.setTableRowHight();
        this.switchReorderingOfTableColumnsOff();
        this.initTableButtonEditorAndRenderer();
        this.initTableSorter();
    }

    private void initTableModel() {
        this.table.setModel(this.tableModel);
    }

    private void initTableColumnModel() {
        this.table.setColumnModel(new KanjiTableColumnModel());
    }

    private void initTableRenderer() {
        this.tableRenderer.setFontSize(15.0f);
        this.table.setDefaultRenderer(Object.class, this.tableRenderer);
    }

    private void setTableSelectionMode() {
        this.table.setSelectionMode(0);
    }

    private void setTableRowHight() {
        this.tableRenderer.initRowHeightOfTable(this.table);
    }

    private void switchReorderingOfTableColumnsOff() {
        this.table.getTableHeader().setReorderingAllowed(false);
    }

    private void initTableButtonEditorAndRenderer() {
        new ButtonColumn(this.table, n -> this.reactOnShowKanjiVocablesButtonClick(n), 9);
        new ButtonColumn(this.table, n -> this.reactOnShowKanjiDetailsButtonClick(n), 16);
    }

    private void reactOnShowKanjiVocablesButtonClick(int n) {
        Kanji kanji = this.kanjiList.get(n);
        List<Vocable> list = this.determineVocablesWithKanji(kanji);
        if (!list.isEmpty()) {
            VocabularyListerDialog vocabularyListerDialog = new VocabularyListerDialog(this.options, this.requester, list, "Vokabeln mit Kanji " + kanji.getCharacter(), this.kanjiRequester, this.informer, this.ownLists, this.messageSetter, this.getLocation(), this.getProgramImage());
            vocabularyListerDialog.setVisible(true);
        }
    }

    private List<Vocable> determineVocablesWithKanji(Kanji kanji) {
        String string = kanji.getCharacter();
        ArrayList<Vocable> arrayList = new ArrayList<Vocable>();
        for (Vocabulary vocabulary : this.vocabularies) {
            for (Vocable vocable : vocabulary.getVocables()) {
                if (!vocable.getKanji().contains(string)) continue;
                arrayList.add(vocable);
            }
        }
        return arrayList;
    }

    private void reactOnShowKanjiDetailsButtonClick(int n) {
        Kanji kanji = this.kanjiList.get(n);
        KanjiDetailDialog kanjiDetailDialog = new KanjiDetailDialog(kanji, this.kanjiRequester, this.getParentLocation(), this.getProgramImage());
        kanjiDetailDialog.setVisible(true);
    }

    private void initTableSorter() {
        TableRowSorter<KanjiTableModel> tableRowSorter = new TableRowSorter<KanjiTableModel>(this.tableModel);
        this.table.setRowSorter(tableRowSorter);
    }

    private void initScrollPane() {
        this.scrollPane = GuiTools.createScrollPane(this.table);
    }

    @Override
    protected void populateDialog() {
        this.initElements();
        this.add(this.createCenterPart(), "Center");
        this.add(this.createButtonsPart(), "South");
        GuiTools.scrollScrollbarToMinimumLater(this.scrollPane);
    }

    private void initElements() {
        this.initIncreaseFontSizeButton();
        this.initStandardFontSizeButton();
        this.initDecreaseFontSizeButton();
    }

    private void initIncreaseFontSizeButton() {
        this.increaseFontSizeButton.setText("+");
        this.increaseFontSizeButton.addActionListener(actionEvent -> this.increaseFontSize());
    }

    private void increaseFontSize() {
        this.tableRenderer.increaseFontSize();
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    private void initStandardFontSizeButton() {
        String string = "default size (" + NumberString.twoDecimalPlaces(15.0) + ")";
        this.standardFontSizeButton.setText(string);
        this.standardFontSizeButton.addActionListener(actionEvent -> this.standardFontSize());
    }

    private void standardFontSize() {
        this.tableRenderer.setFontSize(15.0f);
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    private void initDecreaseFontSizeButton() {
        this.decreaseFontSizeButton.setText("-");
        this.decreaseFontSizeButton.addActionListener(actionEvent -> this.decreaseFontSize());
    }

    private void decreaseFontSize() {
        this.tableRenderer.decreaseFontSize();
        this.tableRenderer.initRowHeightOfTable(this.table);
        this.table.repaint();
    }

    private Component createCenterPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)this.scrollPane, "Center");
        return jPanel;
    }

    private Component createButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createFontSizeAndColorButtonsPart(), "West");
        jPanel.add(this.createQuitButton(), "East");
        return jPanel;
    }

    private Component createFontSizeAndColorButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 3, 0));
        jPanel.add(this.createFontSizeButtonsPart());
        jPanel.add(this.createColorButtonsPart());
        return jPanel;
    }

    private Component createFontSizeButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 3, 0));
        jPanel.add(this.decreaseFontSizeButton);
        jPanel.add(this.standardFontSizeButton);
        jPanel.add(this.increaseFontSizeButton);
        return jPanel;
    }

    private Component createColorButtonsPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(0, 3, 0));
        jPanel.add(this.createSwitchForegroundColorButton());
        jPanel.add(this.createSwitchBackgroundColorButton());
        return jPanel;
    }

    private Component createSwitchForegroundColorButton() {
        JButton jButton = new JButton("toggle Vordergrundfarbe");
        jButton.addActionListener(actionEvent -> this.toggleColorForegroundDependingOnLastSuccess());
        return jButton;
    }

    private void toggleColorForegroundDependingOnLastSuccess() {
        this.tableRenderer.toggleColorForegroundDependingOnLastSuccess();
        this.table.repaint();
    }

    private Component createSwitchBackgroundColorButton() {
        JButton jButton = new JButton("toggle Hintergrundfarbe");
        jButton.addActionListener(actionEvent -> this.toggleColorBackgroundDependingOnLastSuccess());
        return jButton;
    }

    private void toggleColorBackgroundDependingOnLastSuccess() {
        this.tableRenderer.toggleColorBackgroundDependingOnLastSuccess();
        this.table.repaint();
    }

    private Component createQuitButton() {
        JButton jButton = new JButton("Beenden");
        jButton.addActionListener(actionEvent -> this.quit());
        return jButton;
    }

    private void quit() {
        this.closeDialog();
    }
}

