/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.components;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.components.data.ButtonAndFontName;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class BigKanjiDisplay {
    private static final int DEFAULT_BIGGER_FONT_SIZE = 400;
    private static final List<String> FONT_NAMES = CollectionsHelper.buildListFrom(new JLabel().getFont().getFontName(), "MS Gothic", "Yu Gothic");
    private final JPanel panel = new JPanel();
    private final JLabel label = new JLabel();
    private String fontName = FONT_NAMES.get(0);
    private int biggerFontSize = 400;
    private boolean fontNameAndSizeSet = false;
    private List<ButtonAndFontName> fontButtons;
    private Runnable afterFontButtonPressedRunnable = null;
    private boolean afterFontButtonPressedRunnableSet = false;

    public BigKanjiDisplay() {
        this.initPanel();
        this.initLabel();
        this.createButtons();
        this.setFontButtonsBorder();
        this.fillPanel();
    }

    private void initPanel() {
        this.panel.setLayout(new BorderLayout());
    }

    private void initLabel() {
        this.label.setOpaque(true);
        this.label.setBackground(Color.WHITE);
        this.label.setHorizontalAlignment(0);
        this.label.setVerticalAlignment(0);
    }

    private void createButtons() {
        this.fontButtons = new ArrayList<ButtonAndFontName>();
        int n = 0;
        for (String string : FONT_NAMES) {
            JButton jButton = this.createFontButton(string, ++n);
            this.fontButtons.add(new ButtonAndFontName(string, jButton));
        }
    }

    private JButton createFontButton(String string, int n) {
        JButton jButton = new JButton("Font " + n);
        jButton.addActionListener(actionEvent -> this.fontButtonPressed(string));
        return jButton;
    }

    private void fontButtonPressed(String string) {
        this.fontName = string;
        this.fontNameAndSizeSet = false;
        this.setFontNameAndSizeIfNecessary();
        this.setFontButtonsBorder();
        if (this.afterFontButtonPressedRunnableSet) {
            this.afterFontButtonPressedRunnable.run();
        }
    }

    private void setFontButtonsBorder() {
        for (ButtonAndFontName buttonAndFontName : this.fontButtons) {
            String string = buttonAndFontName.getFontName();
            JButton jButton = buttonAndFontName.getButton();
            this.setFontButtonBorder(string, jButton);
        }
    }

    private void setFontButtonBorder(String string, JButton jButton) {
        boolean bl = string.equals(this.fontName);
        if (bl) {
            jButton.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            jButton.setBorder(BorderFactory.createRaisedBevelBorder());
        }
    }

    private void fillPanel() {
        this.panel.add((Component)this.label, "Center");
        this.panel.add(this.createButtonPart(), "South");
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 0, 2, 2));
        for (ButtonAndFontName buttonAndFontName : this.fontButtons) {
            JButton jButton = buttonAndFontName.getButton();
            jPanel.add(jButton);
        }
        return jPanel;
    }

    public void setAfterFontButtonPressedRunnable(Runnable runnable) {
        this.afterFontButtonPressedRunnable = runnable;
        this.afterFontButtonPressedRunnableSet = true;
    }

    public void setBiggerFontSize(int n) {
        this.biggerFontSize = n;
    }

    public void showKanji(Kanji kanji) {
        this.setFontNameAndSizeIfNecessary();
        String string = kanji.getCharacter();
        this.label.setText(string);
    }

    private void setFontNameAndSizeIfNecessary() {
        if (!this.fontNameAndSizeSet) {
            Font font = new JLabel().getFont();
            int n = font.getSize() + this.biggerFontSize;
            Font font2 = new Font(this.fontName, font.getStyle(), n);
            this.label.setFont(font2);
            this.fontNameAndSizeSet = true;
        }
    }

    public JComponent getComponent() {
        return this.panel;
    }
}

