/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.dialog.ownlist;

import de.duehl.basics.text.html.HtmlTool;
import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.dialogs.base.ModalDialogBase;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.data.OwnList;
import de.duehl.vocabulary.japanese.logic.ownlists.OwnLists;
import de.duehl.vocabulary.japanese.ui.listcommander.selector.OwnListSelector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class OwnListSelectionDialog
extends ModalDialogBase {
    private static final Dimension DIALOG_DIMENSION = new Dimension(800, 300);
    private final String text;
    private final OwnListSelector selector;
    private boolean applied;
    private OwnList ownList;

    public OwnListSelectionDialog(String string, String string2, OwnLists ownLists, Point point, Image image) {
        super(point, image, string, DIALOG_DIMENSION);
        this.text = string2;
        Options options = ownLists.getOptions();
        this.selector = new OwnListSelector(ownLists, ownList -> this.selectedOwnListChanged(ownList), options.getHistoricalOwnLists(), point, image);
        this.applied = false;
        this.fillDialog();
    }

    private void selectedOwnListChanged(OwnList ownList) {
        this.ownList = ownList;
    }

    @Override
    protected void populateDialog() {
        this.add(this.createTextPart(), "Center");
        this.add(this.createOwnListSelectorAndButtonPart(), "South");
    }

    private Component createTextPart() {
        String string = HtmlTool.htmlify(this.text);
        JLabel jLabel = new JLabel(string);
        GuiTools.biggerFont(jLabel, 10);
        jLabel.setBorder(BorderFactory.createEmptyBorder(10, 25, 10, 25));
        return jLabel;
    }

    private Component createOwnListSelectorAndButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createOwnListSelectorPart(), "Center");
        jPanel.add(this.createButtonPart(), "South");
        return jPanel;
    }

    private Component createOwnListSelectorPart() {
        return this.selector.getPanel();
    }

    private Component createButtonPart() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createSelectOwnListButton(), "Center");
        return jPanel;
    }

    private Component createSelectOwnListButton() {
        JButton jButton = new JButton("Angezeigte Liste ausw\u00e4hlen");
        jButton.addActionListener(actionEvent -> this.selectOwnList());
        return jButton;
    }

    private void selectOwnList() {
        this.applied = true;
        this.closeDialog();
    }

    public boolean isApplied() {
        return this.applied;
    }

    public OwnList getOwnList() {
        return this.ownList;
    }
}

