/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.ui.tools;

import de.duehl.basics.text.NumberString;
import de.duehl.swing.ui.resources.IconLoader;
import de.duehl.vocabulary.japanese.common.persistence.Options;
import de.duehl.vocabulary.japanese.common.ui.resources.IconDefinitions;
import de.duehl.vocabulary.japanese.data.Vocable;
import de.duehl.vocabulary.japanese.data.symbol.Hiragana;
import de.duehl.vocabulary.japanese.data.symbol.Kanji;
import de.duehl.vocabulary.japanese.data.symbol.Katakana;
import de.duehl.vocabulary.japanese.logic.internal.InternalDataRequester;
import de.duehl.vocabulary.japanese.logic.success.HiraganaListTestSuccesssCalculator;
import de.duehl.vocabulary.japanese.logic.success.KanjiListTestSuccesssCalculator;
import de.duehl.vocabulary.japanese.logic.success.KatakanaListTestSuccesssCalculator;
import de.duehl.vocabulary.japanese.logic.success.VocabularyTestSuccesssCalculator;
import de.duehl.vocabulary.japanese.logic.symbol.kana.internal.InternalKanaDataRequester;
import de.duehl.vocabulary.japanese.logic.symbol.kanji.internal.InternalKanjiDataRequester;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;

public class VocabularyTrainerUiTools {
    public static String generateTitleWithVocabularyTestSuccesss(Options options, InternalDataRequester internalDataRequester, List<Vocable> list, String string) {
        VocabularyTestSuccesssCalculator vocabularyTestSuccesssCalculator = new VocabularyTestSuccesssCalculator(list, options, internalDataRequester);
        vocabularyTestSuccesssCalculator.calculate();
        String string2 = vocabularyTestSuccesssCalculator.getPercentTextWithTwoDigitsAfterComma();
        return string + " (" + string2 + "%)";
    }

    public static String generateTitleWithKanjiTestSuccesss(Options options, InternalKanjiDataRequester internalKanjiDataRequester, List<Kanji> list, String string) {
        KanjiListTestSuccesssCalculator kanjiListTestSuccesssCalculator = new KanjiListTestSuccesssCalculator(list, options, internalKanjiDataRequester);
        kanjiListTestSuccesssCalculator.calculate();
        String string2 = kanjiListTestSuccesssCalculator.getPercentTextWithTwoDigitsAfterComma();
        return string + " (" + string2 + "%)";
    }

    public static String generateTitleWithHiraganaTestSuccesss(Options options, InternalKanaDataRequester internalKanaDataRequester, List<Hiragana> list, String string) {
        HiraganaListTestSuccesssCalculator hiraganaListTestSuccesssCalculator = new HiraganaListTestSuccesssCalculator(list, options, internalKanaDataRequester);
        hiraganaListTestSuccesssCalculator.calculate();
        String string2 = hiraganaListTestSuccesssCalculator.getPercentTextWithTwoDigitsAfterComma();
        return string + " (" + string2 + "%)";
    }

    public static String generateTitleWithKatakanaTestSuccesss(Options options, InternalKanaDataRequester internalKanaDataRequester, List<Katakana> list, String string) {
        KatakanaListTestSuccesssCalculator katakanaListTestSuccesssCalculator = new KatakanaListTestSuccesssCalculator(list, options, internalKanaDataRequester);
        katakanaListTestSuccesssCalculator.calculate();
        String string2 = katakanaListTestSuccesssCalculator.getPercentTextWithTwoDigitsAfterComma();
        return string + " (" + string2 + "%)";
    }

    public static double createLastTenTestsPercent(Options options, InternalDataRequester internalDataRequester, List<Vocable> list) {
        VocabularyTestSuccesssCalculator vocabularyTestSuccesssCalculator = new VocabularyTestSuccesssCalculator(list, options, internalDataRequester);
        vocabularyTestSuccesssCalculator.calculate();
        return vocabularyTestSuccesssCalculator.getPercent();
    }

    public static double createLastTenKanjiTestsPercent(Options options, InternalKanjiDataRequester internalKanjiDataRequester, List<Kanji> list) {
        KanjiListTestSuccesssCalculator kanjiListTestSuccesssCalculator = new KanjiListTestSuccesssCalculator(list, options, internalKanjiDataRequester);
        kanjiListTestSuccesssCalculator.calculate();
        return kanjiListTestSuccesssCalculator.getPercent();
    }

    public static double createLastTenHiraganaTestsPercent(Options options, InternalKanaDataRequester internalKanaDataRequester, List<Hiragana> list) {
        HiraganaListTestSuccesssCalculator hiraganaListTestSuccesssCalculator = new HiraganaListTestSuccesssCalculator(list, options, internalKanaDataRequester);
        hiraganaListTestSuccesssCalculator.calculate();
        return hiraganaListTestSuccesssCalculator.getPercent();
    }

    public static double createLastTenKatakanaTestsPercent(Options options, InternalKanaDataRequester internalKanaDataRequester, List<Katakana> list) {
        KatakanaListTestSuccesssCalculator katakanaListTestSuccesssCalculator = new KatakanaListTestSuccesssCalculator(list, options, internalKanaDataRequester);
        katakanaListTestSuccesssCalculator.calculate();
        return katakanaListTestSuccesssCalculator.getPercent();
    }

    public static JButton createPicturedButton(String string, ActionListener actionListener, String string2) {
        JButton jButton = new JButton(VocabularyTrainerUiTools.loadIcon(string));
        jButton.setBorder(BorderFactory.createRaisedBevelBorder());
        jButton.addActionListener(actionListener);
        jButton.setToolTipText(string2);
        return jButton;
    }

    private static Icon loadIcon(String string) {
        IconDefinitions iconDefinitions = new IconDefinitions();
        IconLoader iconLoader = iconDefinitions.createIconLoader();
        return iconLoader.loadIcon(string);
    }

    public static String createAllTestsMessage(String string, String string2, int n, int n2) {
        double d;
        String string3 = "Sie haben " + NumberString.taupu(n2) + " von " + NumberString.taupu(n) + " " + string + " richtig " + string2 + ".";
        Object object = n == n2 ? "Sehr gut, alles richtig " + string2 + "!" : ((d = NumberString.percentAsNumber(n2, n)) >= 90.0 ? "Das war schon sehr gut!" : (d >= 75.0 ? "Ein gutes Ergebnis!" : (d >= 50.0 ? "Immerhin war mindestens die H\u00e4lfte richtig." : (d >= 25.0 ? "Es wird, aber es gibt noch viel Luft nach oben." : "\u00dcben, \u00fcben, \u00fcben ..."))));
        return string3 + "<br/>" + (String)object;
    }
}

