/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.website.update.ownlists;

import de.duehl.vocabulary.japanese.common.website.update.UpdateTools;
import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.website.download.NewestOwnListVersionListDownloader;
import de.duehl.vocabulary.japanese.website.update.ownlists.GroupsDownloader;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.NewestOwnListVersionListEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.OwnListInterestAndVersionEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.interest.OwnListVersionAndInterestIo;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public class GroupsOfOwnListsFromWebsiteImporter {
    private final VocabularyTrainerLogic logic;
    private final VocabularyTrainerGui gui;
    private List<NewestOwnListVersionListEntry> newestOwnListVersionEntries;
    private List<OwnListInterestAndVersionEntry> interestAndVersionEntries;
    private List<String> newerOrUnseenGroupNames;

    public GroupsOfOwnListsFromWebsiteImporter(VocabularyTrainerLogic vocabularyTrainerLogic, VocabularyTrainerGui vocabularyTrainerGui) {
        this.logic = vocabularyTrainerLogic;
        this.gui = vocabularyTrainerGui;
    }

    public void importGroups() {
        this.newestOwnListVersionEntries = NewestOwnListVersionListDownloader.download();
        if (this.newestOwnListVersionEntries.isEmpty()) {
            UpdateTools.informUserAboutDownloadFailure("der eigenen Listen", this.gui.getLocation(), this.gui.getProgramImage());
        } else {
            this.interestAndVersionEntries = OwnListVersionAndInterestIo.loadOwnListVersionAndInterests();
            this.newerOrUnseenGroupNames = new ArrayList<String>();
            this.downloadAndImportGroups();
        }
    }

    private void downloadAndImportGroups() {
        SwingUtilities.invokeLater(() -> this.downloadAndImportGroupsInEdt());
    }

    private void downloadAndImportGroupsInEdt() {
        GroupsDownloader groupsDownloader = new GroupsDownloader(this.logic, this.gui, this.newestOwnListVersionEntries, this.interestAndVersionEntries, this.newerOrUnseenGroupNames);
        groupsDownloader.download();
    }
}

