/*
 * Decompiled with CFR 0.152.
 */
package de.duehl.vocabulary.japanese.website.update.ownlists.parser;

import de.duehl.basics.collections.CollectionsHelper;
import de.duehl.basics.text.Text;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.NewestOwnListVersionListEntry;
import java.util.ArrayList;
import java.util.List;

public class NewestOwnListsVersionParser {
    private final String content;
    private List<String> lines;
    private boolean success;
    private String failReason;
    private List<NewestOwnListVersionListEntry> newestOwnListVersionListEntries;

    public NewestOwnListsVersionParser(String string) {
        this.content = string;
    }

    public void parse() {
        this.init();
        this.splitContent();
        this.parseLines();
        this.removeAllEntriesIfErrorOccured();
    }

    private void init() {
        this.success = true;
        this.failReason = "";
        this.newestOwnListVersionListEntries = new ArrayList<NewestOwnListVersionListEntry>();
    }

    private void splitContent() {
        this.lines = Text.splitByLineBreaks(this.content);
        CollectionsHelper.removeEmptyAndOnlyWhitespaceStringsFromList(this.lines);
    }

    private void parseLines() {
        for (String string : this.lines) {
            NewestOwnListVersionListEntry newestOwnListVersionListEntry = this.tryTpParseLine(string);
            this.newestOwnListVersionListEntries.add(newestOwnListVersionListEntry);
        }
    }

    private NewestOwnListVersionListEntry tryTpParseLine(String string) {
        try {
            return NewestOwnListVersionListEntry.createFromLine(string);
        }
        catch (Exception exception) {
            this.fail("Die Zeile '" + string + "' l\u00e4sst sich nicht parsen: " + exception.getMessage());
            return new NewestOwnListVersionListEntry("", 0);
        }
    }

    private void removeAllEntriesIfErrorOccured() {
        if (!this.success) {
            this.newestOwnListVersionListEntries.clear();
        }
    }

    private void fail(String string) {
        this.success = false;
        this.failReason = string;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getFailReason() {
        return this.failReason;
    }

    public List<NewestOwnListVersionListEntry> getNewestOwnListVersionListEntries() {
        return this.newestOwnListVersionListEntries;
    }
}

