package de.duehl.basics.io.done;

/*
 * Copyright 2019 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Diese Klasse stellt eine Liste von Done-Objekten dar und bietet Methoden rund um das Hinzufügen,
 * Entfernen und Abfragen von solchen.
 *
 * @version 1.01     2019-12-17
 * @author Christian Dühl
 */

public class DoneList implements Iterable<Done> {

    /** Liste der Marker für fertige Arbeitsschritte. */
    private final List<Done> listOfDone;

    /** Konstruktor. */
    public DoneList() {
        listOfDone = new ArrayList<>();
    }

    @Override
    public Iterator<Done> iterator() {
        return listOfDone.iterator();
    }

    /** Fügt einen Marker für fertige Arbeitsschritte zur Liste hinzu. */
    public void add(Done done) {
        listOfDone.add(done);
    }

    /**
     * Fügt einen direkt erstellten Marker für fertige Arbeitsschritte zur Liste hinzu.
     *
     * @param fileToCreateDoneFileFor
     *            Name der Datei, zu der ein Marker zur Fertigstellung erzeugt werden soll.
     */
    public void createDoneAndAdd(String fileToCreateDoneFileFor) {
        add(new Done(fileToCreateDoneFileFor));
    }

    /** Entfernt einen Marker für fertige Arbeitsschritte aus der Liste. */
    public void remove(Done done) {
        listOfDone.remove(done);
    }

    /** Entfernt einen Marker für fertige Arbeitsschritte über seinen Index aus der Liste. */
    public void remove(int index) {
        listOfDone.remove(index);
    }

    /** Gibt an, ob die Liste der Marker für fertige Arbeitsschritte leer ist. */
    public boolean isEmpty() {
        return listOfDone.isEmpty();
    }

    /** Leert die Liste der Marker für fertige Arbeitsschritte. */
    public void clear() {
        listOfDone.clear();
    }

    /** Gibt an, ob alle Marker für fertige Arbeitsschritte im Dateisystem angelegt wurden. */
    public boolean existAllDoneMarkers() {
        for (Done done : listOfDone) {
            if (done.isDoneMarkerMissing()) {
                return false;
            }
        }
        return true;
    }

    /** Entfernt alle Marker für fertige Arbeitsschritte im Dateisystem. */
    public void deleteAllDoneFiles() {
        for (Done done : listOfDone) {
            done.deleteDoneFile();
        }
    }

    /** Gibt die Anzahl der Done-Objekte in der Liste an. */
    public int size() {
        return listOfDone.size();
    }

}
