package de.duehl.basics.system;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.net.InetAddress;
import java.net.UnknownHostException;

/**
 * Diese Klasse kann danach gefragt werden, wo gerade das Programm ausgeführt
 * wird.
 *
 * @version 1.01     2017-03-01
 * @author Christian Dühl
 */

public class WhereAreWe {

    /** Privater Konstruktor. */
    private WhereAreWe() {}

    /** Gibt an, ob das Programm bei der Arbeit ausgeführt wird. */
    public static boolean areWeAtWork() {
        WhereAreWe whereAreWe = new WhereAreWe();
        return whereAreWe.atWork();
    }

    /** Gibt an, ob das Programm zu Hause ausgeführt wird. */
    public static boolean areWeAtHome() {
        return !areWeAtWork();
    }

    /**
     * Ermittelt anhand der lokalen IP-Adresse, ob das Programm zu Hause oder auf der Arbeit
     * gestartet wird.
     *
     * @return true: Start auf der Arbeit, false: Start zu Hause
     */
    public boolean atWork() {
        try {
            return tryAtWork();
        }
        catch (UnknownHostException e) {
            return true;
        }
    }

    /**
     * Ermittelt anhand der lokalen IP-Adresse, ob das Programm zu Hause oder auf der Arbeit
     * gestartet wird.
     *
     * @return true: Start auf der Arbeit, false: Start zu Hause
     * @throws UnknownHostException
     */
    private boolean tryAtWork() throws UnknownHostException {
        InetAddress inetAddress = InetAddress.getLocalHost();
        String address = inetAddress.getHostAddress();
        return address.startsWith("192.168.30.") || address.startsWith("192.168.29.");
    }


}
