package de.duehl.basics.io.textfile;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.assertEquals;

import java.io.File;
import java.util.List;

import org.junit.Test;

import de.duehl.basics.io.Charset;
import de.duehl.basics.io.FileHelper;
import de.duehl.basics.test.TestHelper;

public class StringsFromNormalTextFileReaderTest {

    private final String path;

    public StringsFromNormalTextFileReaderTest() {
        TestHelper testHelper = TestHelper.createForBasics(getClass(), 7);
        path =  testHelper.getTestDataPath() + File.separator;
    }


    /* -------------------------- TESTS -------------------------- */


    @Test
    public void readStandard() {
        StringsFromTextFileReader reader = new StringsFromNormalTextFileReader(
                FileHelper.concatPathes(path, "test_datei.txt"), Charset.UTF_8, "#");
        reader.beQuiet();
        List<String> list = reader.read();
        assertEquals(4, list.size());
        assertEquals("eins", list.get(0));
        assertEquals("zwei", list.get(1));
        assertEquals("drei", list.get(2));
        assertEquals("GroßBuchstAben?", list.get(3));
    }

    @Test
    public void readNoTrim() {
        StringsFromTextFileReader reader = new StringsFromNormalTextFileReader(
                FileHelper.concatPathes(path, "test_datei.txt"), Charset.UTF_8, "#");
        reader.beQuiet();
        reader.doNotTrimLines();
        List<String> list = reader.read();
        assertEquals(4, list.size());
        assertEquals("eins", list.get(0));
        assertEquals("    zwei", list.get(1));
        assertEquals("  drei       ", list.get(2));
        assertEquals("GroßBuchstAben?", list.get(3));
    }

    @Test
    public void readToLowerCase() {
        StringsFromTextFileReader reader = new StringsFromNormalTextFileReader(
                FileHelper.concatPathes(path, "test_datei.txt"), Charset.UTF_8, "#");
        reader.beQuiet();
        reader.changeToLowerCase();
        List<String> list = reader.read();
        assertEquals(4, list.size());
        assertEquals("eins", list.get(0));
        assertEquals("zwei", list.get(1));
        assertEquals("drei", list.get(2));
        assertEquals("großbuchstaben?", list.get(3));
    }

    @Test
    public void readIncludeBlankLines() {
        StringsFromTextFileReader reader = new StringsFromNormalTextFileReader(
                FileHelper.concatPathes(path, "test_datei.txt"), Charset.UTF_8, "#");
        reader.beQuiet();
        reader.includeBlankLinesIntoResult();
        List<String> list = reader.read();
        assertEquals(11, list.size());
        assertEquals("", list.get(0));
        assertEquals("eins", list.get(1));
        assertEquals("", list.get(2));
        assertEquals("", list.get(3));
        assertEquals("zwei", list.get(4));
        assertEquals("", list.get(5));
        assertEquals("drei", list.get(6));
        assertEquals("", list.get(7));
        assertEquals("", list.get(8));
        assertEquals("GroßBuchstAben?", list.get(9));
        assertEquals("", list.get(10));
    }

}
