package de.duehl.basics.regex;

/*
 * Copyright 2024 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.List;
import java.util.regex.Pattern;

import org.junit.Test;

public class MultipleTextPartsWithRegexReplacerTest {

    @Test
    public void test1() {
        String text = "Der Hund und die Katze machen einen Ausflug.";
        String regex = "(?:Katze|Ausflug|Hund)";
        Pattern pattern = Pattern.compile(regex);
        String placeholder = "<<PLATZHALTER>>";
        MultipleTextPartsWithRegexReplacer replacer = new MultipleTextPartsWithRegexReplacer(text,
                pattern, placeholder);
        replacer.replace();

        String actualEnt = replacer.getEnt();
        String expectedEnt =
                "Der <<PLATZHALTER>> und die <<PLATZHALTER>> machen einen <<PLATZHALTER>>.";
        assertEquals(expectedEnt, actualEnt);

        List<String> foundParts = replacer.getFoundParts();
        assertEquals(3, foundParts.size());
        assertEquals("Hund", foundParts.get(0));
        assertEquals("Katze", foundParts.get(1));
        assertEquals("Ausflug", foundParts.get(2));
    }

}
