package de.duehl.basics.regex;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import java.util.regex.Pattern;

import org.junit.Test;

public class SubstitutionTest {

    @Test
    public void createTwoParameters() {
        Substitution substitution = new Substitution("foo", "bar");
        assertNotNull(substitution);
    }

    @Test
    public void createThreeParameters() {
        Substitution substitution = new Substitution("foo", Pattern.DOTALL, "bar");
        assertNotNull(substitution);
    }

    @Test
    public void getRegexTwoParameters() {
        Substitution substitution = new Substitution("foo", "bar");
        String actual = substitution.getRegex();
        String expected = "foo";
        assertEquals(expected, actual);
    }

    @Test
    public void getRegexThreeParameters() {
        Substitution substitution = new Substitution("foo", Pattern.DOTALL, "bar");
        String actual = substitution.getRegex();
        String expected = "foo";
        assertEquals(expected, actual);
    }

    @Test
    public void substituteTwoParameters() {
        Substitution substitution = new Substitution("foo", "bar");
        String actual = substitution.substitute("foo und foo - und foo!");
        String expected = "bar und bar - und bar!";
        assertEquals(expected, actual);
    }

    @Test
    public void substituteThreeParameters() {
        Substitution substitution = new Substitution("foo", Pattern.DOTALL, "bar");
        String actual = substitution.substitute("foo und foo - und foo!");
        String expected = "bar und bar - und bar!";
        assertEquals(expected, actual);
    }

    @Test
    public void substituteAbcTwoParameters() {
        Substitution substitution = new Substitution("a.*z", "ABC");
        String actual = substitution.substitute("abcdef   ghllksjd    \t        xyz");
        String expected = "ABC";
        assertEquals(expected, actual);
    }

    @Test
    public void substituteAbcThreeParameters() {
        Substitution substitution = new Substitution("a.*z", Pattern.DOTALL, "ABC");
        String actual = substitution.substitute("abcdef   ghllksjd    \t        xyz");
        String expected = "ABC";
        assertEquals(expected, actual);
    }

    @Test
    public void substituteAbcTwoParametersWithLineBreak() {
        Substitution substitution = new Substitution("a.*z", "ABC");
        String actual = substitution.substitute("abcdef   ghllksjd    \t    \n    xyz");
        String expected = "abcdef   ghllksjd    \t    \n    xyz";
        assertEquals(expected, actual);
    }

    @Test
    public void substituteAbcThreeParametersWithLineBreak() {
        Substitution substitution = new Substitution("a.*z", Pattern.DOTALL, "ABC");
        String actual = substitution.substitute("abcdef   ghllksjd    \t    \n    xyz");
        String expected = "ABC";
        assertEquals(expected, actual);
    }

    /* Achtung! */
    @Test
    public void Test001() {
        String input = "So ein bla, bla und bla.";
        Substitution sub = new Substitution("(.*)bla(.*)", "$1foo$2");
        String result = sub.substitute(input);
        assertEquals("So ein bla, bla und foo.", result);
    }

    @Test
    public void Test002() {
        String input = "So ein bla, bla und bla.";
        Substitution sub = new Substitution("bla", "foo");
        String result = sub.substitute(input);
        assertEquals("So ein foo, foo und foo.", result);
    }

}
