package de.duehl.basics.version;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

import de.duehl.basics.text.Text;

public class ChangesBetweenVersionsCutterTest {

    private static final String CHANGES_HTML_1_INNER = ""
            + "    <h2>Version 4 vom 16.12.2020</h2>" + Text.LINE_BREAK
            + "    <ul>" + Text.LINE_BREAK
            + "        <li>" + Text.LINE_BREAK
            + "            bla bla" + Text.LINE_BREAK
            + "        </li>" + Text.LINE_BREAK
            + "    </ul>" + Text.LINE_BREAK
            + "<!-- Kommentar -->" + Text.LINE_BREAK
            + "    <h2>Version 3 vom 15.12.2020</h2>" + Text.LINE_BREAK
            + "    <ul>" + Text.LINE_BREAK
            + "        <li>" + Text.LINE_BREAK
            + "            bla bla" + Text.LINE_BREAK
            + "        </li>" + Text.LINE_BREAK
            + "    </ul>" + Text.LINE_BREAK
            + "" + Text.LINE_BREAK
            + "    <h2>Version 2 vom 14.12.2020</h2>" + Text.LINE_BREAK
            + "    <ul>" + Text.LINE_BREAK
            + "        <li>" + Text.LINE_BREAK
            + "            bla bla" + Text.LINE_BREAK
            + "        </li>" + Text.LINE_BREAK
            + "    </ul>" + Text.LINE_BREAK
            + "" + Text.LINE_BREAK
            + "    <h2>Version 1 vom 11.12.2020</h2>" + Text.LINE_BREAK
            + "    <ul>" + Text.LINE_BREAK
            + "        <li>" + Text.LINE_BREAK
            + "            bla bla" + Text.LINE_BREAK
            + "        </li>" + Text.LINE_BREAK
            + "    </ul>" + Text.LINE_BREAK
            ;

    private static final String CHANGES_HTML_1 = ""
            + "<html>" + Text.LINE_BREAK
            + "" + Text.LINE_BREAK
            + "<body>" + Text.LINE_BREAK
            + "" + Text.LINE_BREAK
            + CHANGES_HTML_1_INNER
            + "" + Text.LINE_BREAK
            + "</body>" + Text.LINE_BREAK
            + "" + Text.LINE_BREAK
            + "</html>" + Text.LINE_BREAK
            ;

    @Test
    public void example1() {
        Version actualVersion = new Version("4", "Dezember 2020");
        Version lastVersion = new Version("2", "Dezember 2020");
        String changesHtml = CHANGES_HTML_1;
        ChangesBetweenVersionsCutter cutter = new ChangesBetweenVersionsCutter(actualVersion,
                lastVersion, changesHtml);
        String actual = cutter.detectChangesBetweenVersions();
        String expected = ""
                + "    <h2>Version 4 vom 16.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                + "    <h2>Version 3 vom 15.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                ;
        assertEquals(expected, actual);
    }

    @Test
    public void example2() {
        Version actualVersion = new Version("4", "Dezember 2020");
        Version lastVersion = new Version("1", "Dezember 2020");
        String changesHtml = CHANGES_HTML_1;
        ChangesBetweenVersionsCutter cutter = new ChangesBetweenVersionsCutter(actualVersion,
                lastVersion, changesHtml);
        String actual = cutter.detectChangesBetweenVersions();
        String expected = ""
                + "    <h2>Version 4 vom 16.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                + "    <h2>Version 3 vom 15.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                + "    <h2>Version 2 vom 14.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                ;
        assertEquals(expected, actual);
    }

    @Test
    public void example3() {
        Version actualVersion = new Version("4", "Dezember 2020");
        Version lastVersion = new Version("0", "Dezember 2020");
        String changesHtml = CHANGES_HTML_1;
        ChangesBetweenVersionsCutter cutter = new ChangesBetweenVersionsCutter(actualVersion,
                lastVersion, changesHtml);
        String actual = cutter.detectChangesBetweenVersions();
        String expected = ""
                + "    <h2>Version 4 vom 16.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                + "    <h2>Version 3 vom 15.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                + "    <h2>Version 2 vom 14.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                + "    <h2>Version 1 vom 11.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                ;
        assertEquals(expected, actual);
    }

    @Test
    public void example3inner() {
        Version actualVersion = new Version("4", "Dezember 2020");
        Version lastVersion = new Version("0", "Dezember 2020");
        String changesHtml = CHANGES_HTML_1_INNER;
        ChangesBetweenVersionsCutter cutter = new ChangesBetweenVersionsCutter(actualVersion,
                lastVersion, changesHtml);
        String actual = cutter.detectChangesBetweenVersions();
        String expected = ""
                + "    <h2>Version 4 vom 16.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                + "    <h2>Version 3 vom 15.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                + "    <h2>Version 2 vom 14.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                + "    <h2>Version 1 vom 11.12.2020</h2>" + Text.LINE_BREAK
                + "    <ul>" + Text.LINE_BREAK
                + "        <li>" + Text.LINE_BREAK
                + "            bla bla" + Text.LINE_BREAK
                + "        </li>" + Text.LINE_BREAK
                + "    </ul>" + Text.LINE_BREAK
                + "" + Text.LINE_BREAK
                ;
        assertEquals(expected, actual);
    }


    @Test
    public void wrongVersionOrderLeadsToEmptyString() {
        Version actualVersion = new Version("2", "Dezember 2020");
        Version lastVersion = new Version("4", "Dezember 2020");
        String changesHtml = CHANGES_HTML_1;
        ChangesBetweenVersionsCutter cutter = new ChangesBetweenVersionsCutter(actualVersion,
                lastVersion, changesHtml);
        String actual = cutter.detectChangesBetweenVersions();
        String expected = "";
        assertEquals(expected, actual);
    }

    @Test
    public void sameVersionsLeadsToEmptyString() {
        Version actualVersion = new Version("3", "Dezember 2020");
        Version lastVersion = new Version("3", "Dezember 2020");
        String changesHtml = CHANGES_HTML_1;
        ChangesBetweenVersionsCutter cutter = new ChangesBetweenVersionsCutter(actualVersion,
                lastVersion, changesHtml);
        String actual = cutter.detectChangesBetweenVersions();
        String expected = "";
        assertEquals(expected, actual);
    }

    @Test
    public void lowVersionsLeadsToEmptyString() {
        Version actualVersion = new Version("0.0", "Dezember 2020");
        Version lastVersion = new Version("0", "Dezember 2020");
        String changesHtml = CHANGES_HTML_1;
        ChangesBetweenVersionsCutter cutter = new ChangesBetweenVersionsCutter(actualVersion,
                lastVersion, changesHtml);
        String actual = cutter.detectChangesBetweenVersions();
        String expected = "";
        assertEquals(expected, actual);
    }

    @Test
    public void emptyChangesHtmlLeadsToEmptyOutput() {
        Version actualVersion = new Version("4", "Dezember 2020");
        Version lastVersion = new Version("2", "Dezember 2020");
        String changesHtml = "";
        ChangesBetweenVersionsCutter cutter = new ChangesBetweenVersionsCutter(actualVersion,
                lastVersion, changesHtml);
        String actual = cutter.detectChangesBetweenVersions();
        String expected = "";
        assertEquals(expected, actual);
    }

}
