package de.duehl.swing.ui.elements.watch;

/*
 * Copyright 2021 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.system.SystemTools;

/**
 * Diese Klasse stellt ein Label darf, das die auf ihm angezeigte Uhr automatisch aktualisiert.
 *
 * @version 1.01     2021-03-17
 * @author Christian Dühl
 */

class WatchActualisationRunnable implements Runnable {

    /*
     * TODO
     *
     * 22.07.2025:
     *
     * Sollte man hier nochmal Hand anlegen und diese Klasse testen können, kann man
     *
     *     de.duehl.swing.ui.elements.slider.ActualisationRunnable
     *
     * verwenden, das habe ich hiervon kopiert und von WatchBaseLabel entkoppelt.
     */

    /** Default Zeitraum in Millisekunden zwischen Aktualisierungen. */
    private final static int SLEEP_TIME = 50;

    /** Gibt an, ob die Aktualisierung des Labels läuft. */
    private volatile boolean actualisationRunning;

    /** Das Label, welches hier aktualisiert wird. */
    private final WatchBaseLabel watchBaseLabel;

    /** Zeitraum in Millisekunden zwischen Aktualisierungen. */
    private volatile int sleepTimeMillis;

    /**
     * Konstruktor.
     *
     * @param watchBaseLabel
     *            Das StopWatchLabel, welches hier aktualisiert wird.
     */
    public WatchActualisationRunnable(WatchBaseLabel watchBaseLabel) {
        this.watchBaseLabel = watchBaseLabel;
        sleepTimeMillis = SLEEP_TIME;
    }

    @Override
    public void run() {
        actualisationRunning = true;
        loop();
    }

    private void loop() {
        while (actualisationRunning) {
            watchBaseLabel.setWatchText();
            watchBaseLabel.repaint();
            SystemTools.sleep(sleepTimeMillis);
        }
    }

    /** Beendet die Aktualisierung des StopWatchLabels. */
    public void stop() {
        actualisationRunning = false;
    }

    /**
     * Setzt die Millisekunden zwischen den Aktualisierungen des StopWatchLabels. Default ist 50ms.
     */
    public void setSleepTimeMillis(int sleepTimeMillis) {
        this.sleepTimeMillis = sleepTimeMillis;
    }

}
