package de.duehl.swing.ui.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.JButton;
import javax.swing.JFrame;

import de.duehl.swing.ui.GuiTools;
import de.duehl.swing.ui.layout.VerticalLayout;
import de.duehl.swing.ui.text.html.HtmlFrame;
import de.duehl.basics.io.FineFileReader;

public class HTMLFrameSwingTest {

    public static void main(String[] args) {
        new HTMLFrameSwingTest();
    }

    private JFrame frame;

    public HTMLFrameSwingTest() {
        GuiTools.setNiceLayoutManager();
        frame = new JFrame();
        frame.setPreferredSize(new Dimension(250, 100));
        frame.setTitle("Testprogramm für die EditorDialog.");
        frame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
        frame.setLayout(new VerticalLayout(1, VerticalLayout.BOTH));

        {
            JButton openTextFileButton = new JButton(".html Datei öffnen");
            frame.add(openTextFileButton);
            openTextFileButton.addActionListener(new ActionListener() {
                @Override
                public void actionPerformed(ActionEvent arg0) {
                    openHTMLFile();
                }
            });
        }


        frame.pack();
        frame.setVisible(true);
    }

    /**
     * Fragt den Benutzer nach einer bestimmten Dateiart, die geöffnet werden
     * soll und zeigt die Datei im Editor an.
     */
    private void openHTMLFile() {
        String filename = GuiTools.openFileWithExtension(frame, ".html");
        if (filename.isEmpty()) {
            return;
        }
        FineFileReader reader = new FineFileReader(filename);
        String contents = reader.readFileToString();
        reader.close();

        Image programImage = null;
        HtmlFrame dialog = new HtmlFrame("Datei " + filename, programImage,
                frame.getLocation());
        dialog.setText(contents);
        dialog.setVisible(true);
//        ShowHTMLDialog dialog = new ShowHTMLDialog("Datei " + file.getPath(),
//                contents, true, frame.getLocation());
//        dialog.setVisible(true);
    }


}
