package de.duehl.swing.ui.start.filter.project.gateway;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

public enum TestFilterType {

    /*
     * Die Description ist hier uninteressant, die ist nur abei, weil das im WZ-Projekt auch so ist.
     */

    ALL("Alle Datensätze"),

    NO_WORKING_CODE("unbearbeitete Datensätze"), // '*' oder -1
    WORKING_CODE_ZERO("reine Banz-Datensätze"),
    WORKING_CODE_ONE("Datensätze mit WZ-Code aus dem Firmierungsnamen"),
    WORKING_CODE_TWO("Datensätze von Karl oder Name + Banz"),
    WORKING_CODE_THREE("Datensätze, die mit dem WZ-Tool bearbeitet wurden"),

    NO_CODES("Datensätze ohne WZ-Codes"),
    ONE_CODE("Datensätze mit einem WZ-Code"),
    TWO_CODES("Datensätze mit zwei WZ-Codes"),
    THREE_CODES("Datensätze mit drei WZ-Codes"),
    FOUR_CODES("Datensätze mit vier WZ-Codes"),
    FIVE_CODES("Datensätze mit fünf WZ-Codes"),

    SHORT_TEXT("Datensätze mit kurzem Text"),
    FEW_HITS("Datensätze mit wenigen Treffern"),
    CRITICAL_CODES("Datensätze mit den kritischen WZ-Codes"),

    ONE_UNKNOWN("Datensätze mit einem unerschlossenen Satz"), // genau einer
    ONE_SHORT_UNKNOWN("Datensätze mit einem unerschlossenen, kurzen Satz"), // genau einer

    WITH_TEXT("Datensätze mit einem Suchbegriff im Text oder Firmennamen"),
    WITH_CODE("Datensätze mit einem bestimmtem WZ-Code"),
    DOKNR_STARTS_WITH("Datensätze, deren Doknr mit der Zahl beginnt"),
    DOKNR_ENDS_WITH("Datensätze, deren Doknr auf die Zahl endet"),
    ENTRY_TYPE_CANDIDATES("Datensätze mit Kandidaten auf Hinweise für den Eintragstyp"),

    COMBINED_METHODS("Filterkombination"),
    ;

    private final String description;

    private TestFilterType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

}
