package de.duehl.swing.ui.start.search;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;

import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;

import de.duehl.swing.ui.dialogs.SearchDialog;
import de.duehl.swing.ui.elements.search.SearchReaktor;

/**
 * Diese Klasse testet den Such-Dialog.
 *
 * @version 1.01     2017-12-19
 * @author Christian Dühl
 */

public class SearchDialogTest {

    /** Konstruktor. */
    public SearchDialogTest() {
        SwingUtilities.invokeLater(() -> createAndShowGUI());
    }

    private SearchReaktor createSearchReaktor() {
        return new SearchReaktor() {
            @Override
            public void search(String text) {
                System.out.println("Suchen nach '" + text + "'");
            }

            @Override
            public void searchAgain() {
                System.out.println("Weitersuchen");
            }
        };
    }

    private void createAndShowGUI() {
        JFrame frame = new JFrame("SearchDialog Test");
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setLayout(new BorderLayout());

        frame.add(createSearchButton(), BorderLayout.CENTER);

        frame.setPreferredSize(new Dimension(300, 300));
        frame.pack();
        frame.setVisible(true);
    }

    private Component createSearchButton() {
        JButton button = new JButton("Suchdialog öffnen");
        button.addActionListener(e ->  createSearchDialog());
        return button;
    }

    private void createSearchDialog() {
        JDialog dialog = new SearchDialog(createSearchReaktor()).getRealDialog();
        dialog.setVisible(true);
    }

    /** Startpunkt des Programms, Parameter werden ignoriert. */
    public static void main(String[] args) {
        new SearchDialogTest();
    }

}

