package de.duehl.threads.start;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.threads.BusyRunnable;
import de.duehl.threads.timed.TimedThreadRunner;
import de.duehl.threads.timed.TimedThreadRunner.TaskState;

public class TimedThread3 {

    public static void main(String[] args) {
        int secondsTaskIsRunning = 5;
        int secondsBeforeKill = 60;
        int secondsBetweenWatching = 20;

        BusyRunnable runnable = new BusyRunnable(secondsTaskIsRunning);
        TimedThreadRunner runner = new TimedThreadRunner(secondsBeforeKill,
                1000L * secondsBetweenWatching, runnable);
        System.out.println("VOR runner.runTask()");
        runner.runTask();
        System.out.println("NACH runner.runTask()");
        TaskState state = runner.getTaskState();
        System.out.println("State : " + state);
    }

}

/*

VOR runner.runTask()
Prüfung zu Beginn in Ordnung.
Warte 20 Sekunden...
- BusyRunnable Berechnung: 22
- BusyRunnable Berechnung: 36
- BusyRunnable Berechnung: 48
- BusyRunnable Berechnung: 58
- BusyRunnable Berechnung: 76
- BusyRunnable Berechnung: 76
- BusyRunnable Berechnung: 87
- BusyRunnable Berechnung: 109
- BusyRunnable Berechnung: 124
- BusyRunnable Berechnung: 135
- BusyRunnable beendet
thread wurde während des letzten Wartens beendet.
NACH runner.runTask()
State : FINISHED_IN_TIME

(Er wartet natürlich bis die 20 Sekunden um sind.)

*/