package de.duehl.vocabulary.japanese.data.symbol;

/**
 * Diese Klasse stellt die Unterart von Zeichen einer Kana-Schrift (Hiragana oder Katakana) dar.
 *
 * @version 1.01     2025-01-13
 * @author Christian Dühl
 */

public enum KanaSubType {

    BASIC("Standard"),
    WITH_DAKUTEN("Standard mit Dakuten"),
    WITH_HANDAKUTEN("Standard mit Handakuten"),
    COMPOUND("Zusammengesetzt"),
    COMPOUND_WITH_DAKUTEN("Zusammengesetzt mit Dakuten"),
    COMPOUND_WITH_HANDAKUTEN("Zusammengesetzt mit Handakuten"),
    FOR_FOREIGN_WORDS("Zusammengesetzt für Fremdworte"),
    SMALL("kleine Variante"),
    ;

    /** Die Beschreibung der Unterart. */
    private final String description;

    /**
     * Konstruktor.
     *
     * @param description
     *            Die Beschreibung der Unterart.
     */
    private KanaSubType(String description) {
        this.description = description;
    }

    /** Getter für die Beschreibung der Unterart. */
    public String getDescription() {
        return description;
    }

}
