package de.duehl.vocabulary.japanese.ui.dialog.kanji.kanjitest.components.data;

import javax.swing.JButton;

/**
 * Diese Klasse stellt einen Button zum Umschalten der Schriftart zusammen mit dem Namen der
 * Schriftart dar.
 *
 * @version 1.01     2025-10-28
 * @author Christian Dühl
 */

public class ButtonAndFontName {

    /** Der Name des zum Button gehörigen Fonts. */
    private final String fontName;

    /** Der Button zum Umschalten auf diesen Font. */
    private final JButton button;

    /**
     * Konstruktor.
     *
     * @param fontName
     *            Der Name des zum Button gehörigen Fonts.
     * @param button
     *            Der Button zum Umschalten auf diesen Font.
     */
    public ButtonAndFontName(String fontName, JButton button) {
        this.fontName = fontName;
        this.button = button;
    }

    /** Getter für den Namen des zum Button gehörigen Fonts. */
    public String getFontName() {
        return fontName;
    }

    /** Getter für den Button zum Umschalten auf diesen Font. */
    public JButton getButton() {
        return button;
    }

}
