package de.duehl.vocabulary.japanese.ui.dialog.table.katakana;

import de.duehl.swing.ui.tables.BasicTableColumnModel;

/**
 * Diese Klasse stellt das Column-Modell der Tabelle mit den Katakana dar.
 *
 * @version 1.02     2025-02-02
 * @author Christian Dühl
 */

public class KatakanaTableColumnModel extends BasicTableColumnModel {

    private static final long serialVersionUID = 1L;

    /**
     * Die Tabelle enthält die folgenden Spalten:
     *     - Die laufende Nummer.
     *     - Das Katakana in UTF-8 Darstellung.
     *     - Die Darstellung in Hepburn.
     *     - Der Untertyp der Katakana.
     * Außerdem die folgenden Spalten aus den internen Katakana-Daten:
     *     - Die Anzahl, wie oft das Katakana getestet wurde.
     *     - Die Anzahl, wie oft das Katakana erfolgreich getestet wurde.
     *     - Das Datum des letzten Tests.
     *     - Das Datum des letzten erfolgreichen Tests.
     *     - Das Abschneiden bei den letzten Tests.
     *     - Button zum Betrachten der Katakana mit allen internen Daten
     */
    public KatakanaTableColumnModel() {
        addMinMaxWidthColumn(45, "#");
        addMinWidthColumn(50, "Katakana");
        addMinWidthColumn(50, "Hepburn");
        addMinWidthColumn(120, "Untertyp");

        addMinMaxWidthColumn(60, "Getestet");
        addMinMaxWidthColumn(50, "richtig");
        addMinMaxWidthColumn(90, "zuletzt getestet");
        addMinMaxWidthColumn(90, "zuletzt richtig");
        addMinWidthColumn(100, "letzte 10 Ergebnisse");
        addMinMaxWidthColumn(80, "Interna");
    }

}
