package de.duehl.vocabulary.japanese.website.update.ownlists;

import java.util.ArrayList;
import java.util.List;

import javax.swing.SwingUtilities;

import de.duehl.vocabulary.japanese.logic.VocabularyTrainerLogic;
import de.duehl.vocabulary.japanese.ui.VocabularyTrainerGui;
import de.duehl.vocabulary.japanese.website.download.NewestOwnListVersionListDownloader;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.NewestOwnListVersionListEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.data.OwnListInterestAndVersionEntry;
import de.duehl.vocabulary.japanese.website.update.ownlists.interest.OwnListVersionAndInterestIo;

import static de.duehl.vocabulary.japanese.common.website.update.UpdateTools.informUserAboutDownloadFailure;

/**
 * Diese Klasse erlaubt unabhängig von der Prüfung auf Neuerungen (vgl. Klasse
 * OwnListGroupsUpdater) den Download von Gruppen von eigenen Listen von der Webseite.
 *
 * @version 1.01     2024-11-11
 * @author Christian Dühl
 */

public class GroupsOfOwnListsFromWebsiteImporter {

    /** Die Logik des Vokabel-Trainers. */
    private final VocabularyTrainerLogic logic;

    /** Die grafische Oberfläche des Vokabel-Trainers. */
    private final VocabularyTrainerGui gui;

    /** Die Liste der Einträge in der Datei Neuste_Version_Listen.txt auf dem Server. */
    private List<NewestOwnListVersionListEntry> newestOwnListVersionEntries;

    /**
     * Die Liste der Einträge in der Datei Eigene_Listen_Interessen_und_Versionen.txt auf dem
     * Rechner des Benutzers.
     */
    private List<OwnListInterestAndVersionEntry> interestAndVersionEntries;

    /**
     * Die Liste derjenigen Gruppennamen, die der Benutzer bisher noch nicht oder nur in einer
     * älteren Version kannte.
     */
    private List<String> newerOrUnseenGroupNames;

    /**
     * Konstruktor.
     *
     * @param logic
     *            Die Logik des Vokabel-Trainers.
     * @param gui
     *            Die grafische Oberfläche des Vokabel-Trainers.
     * @param options
     *            Die Programmoptionen.
     */
    public GroupsOfOwnListsFromWebsiteImporter(VocabularyTrainerLogic logic,
            VocabularyTrainerGui gui) {
        this.logic = logic;
        this.gui = gui;
    }

    /** Zeigt den Dialog an und lädt gegebenenfalls Gruppen herunter und installiert diese. */
    public void importGroups() {
        newestOwnListVersionEntries = NewestOwnListVersionListDownloader.download();

        if (newestOwnListVersionEntries.isEmpty()) {
            informUserAboutDownloadFailure("der eigenen Listen", gui.getLocation(),
                    gui.getProgramImage());
        }
        else {
            interestAndVersionEntries = OwnListVersionAndInterestIo.loadOwnListVersionAndInterests();
            newerOrUnseenGroupNames = new ArrayList<>();
            downloadAndImportGroups();
        }
    }

    private void downloadAndImportGroups() {
        SwingUtilities.invokeLater(() -> downloadAndImportGroupsInEdt());
    }

    private void downloadAndImportGroupsInEdt() {
        GroupsDownloader downloader = new GroupsDownloader(logic, gui,
                newestOwnListVersionEntries, interestAndVersionEntries, newerOrUnseenGroupNames);
        downloader.download();
    }

}
