package de.duehl.basics.io;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

/**
 * Diese Klasse liest aus der Standardeingabe.
 *
 * @version 1.05     2020-09-29
 * @author Christian Dühl
 */

public class StdInReader implements Reader {

    private final BufferedReader reader;

    private int lineNumber;

    public StdInReader() {
        reader = new BufferedReader(new InputStreamReader(System.in));
        lineNumber = 0;
    }

    @Override
    public String readNextLine() {
        String eingabe = null;
        try {
            eingabe = reader.readLine();
        }
        catch (IOException e) {
            e.printStackTrace();
            eingabe = "";
        }

        ++lineNumber;
        return eingabe;
    }

    @Override
    public int getLineNumber() {
        return lineNumber;
    }

    @Override
    public void close() {
//        try {
//            reader.close();
//        }
//        catch (IOException e) {
//            e.printStackTrace();
//        }
    }

    @Override
    public List<String> readFileToListOfStrings() {
        throw new UnsupportedOperationException("Die Methode "
                + "readFileToListOfStrings() macht beim Lesen von der "
                + "Standardeingabe keinen Sinn.");
    }

    @Override
    public List<List<String>> readFileToListOfFieldLines() {
        throw new UnsupportedOperationException("Die Methode "
                + "readFileToListOfFieldLines() macht beim Lesen von der "
                + "Standardeingabe keinen Sinn.");
    }

    @Override
    public String readFileToString() {
        throw new UnsupportedOperationException("Die Methode "
                + "readFileToString() macht beim Lesen von der "
                + "Standardeingabe keinen Sinn.");
    }

    @Override
    public List<String> readFieldsLine() {
        String line = readNextLine();
        List<String> fields = new ArrayList<>(Arrays.asList(line.split("\t", -1)));
        return fields;
    }

    @Override
    public String getFileName() {
        throw new RuntimeException("Beim StdInReader gibt es keinen Dateinamen!");
    }

}
