package de.duehl.basics.io.zip;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

/**
 * Diese Klasse stellt Hilfsmethoden rund um das Zippen zur Verfügung.
 *
 * @version 1.01     2020-09-25
 * @author Christian Dühl
 */

public class ZipHelper {

    /**
     * Hängt ein ".zip" an den Dateinamen an, wenn es nicht bereits darauf endet, wobei die Groß-
     * oder Kleinschreibung egal ist, also wird auch an "FOO.ZIP" kein ".zip" angehängt.
     */
    public static String perhapsAddZipExtension(String zipFileName) {
        if (zipFileName.toLowerCase().endsWith(".zip")) {
            return zipFileName;
        }
        else {
            return zipFileName + ".zip";
        }
    }

}
