package de.duehl.basics.serializable;

/*
 * Copyright 2016 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;

/**
 * Diese Klasse kann ein gespeichertes Javaobjekt wieder aus der Datei einlesen.
 *
 * @version 1.01     2016-12-09
 * @author Christian Dühl
 */

public class SaveSerializableObject {

    /** Name der Datei, in die das Javaobjekt gespeichert werden soll. */
    private String filename;

    /**
     * Konstruktor.
     *
     * @param filename
     *            Name der Datei, in die das Javaobjekt gespeichert werden soll.
     */
    public SaveSerializableObject(String filename) {
        this.filename = filename;
    }

    /** Speichert das Objekt. */
    public void save(Serializable serializable) {
        OutputStream fos = null;
        ObjectOutputStream o = null;
        try {
            fos = new FileOutputStream(filename);
            o = new ObjectOutputStream(fos);
            o.writeObject(serializable);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Fehler beim Speichern eines persistenten Objektes.", e);
        }
        finally {
            try {
                o.close();
                fos.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

}
