package de.duehl.basics.text.html.generation;

/*
 * Copyright 2020 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import de.duehl.basics.text.Text;

public enum HtmlHeaderType {

    H1(1),
    H2(2),
    H3(3),
    H4(4),
    H5(5),
    H6(6),
    ;

    private final int depth;
    private final String html;

    private HtmlHeaderType(int depth) {
        this.depth = depth;
        this.html = "h" + depth;
    }

    public String getHtmlTagName() {
        return html;
    }

    public String getContentIndentation() {
        return Text.multipleString("&nbsp;", 4 * (depth - 1));
    }

}
