package de.duehl.basics.io.lock;

/*
 * Copyright 2017 Christian Dühl. All rights reserved.
 *
 * This program is free software. You can redistribute it and/or
 * modify it under the same terms as perl:
 *
 * general:  http://dev.perl.org/licenses/
 * GPL:      http://dev.perl.org/licenses/gpl1.html
 * artistic: http://dev.perl.org/licenses/artistic.html
 */

import static org.junit.Assert.*;

import org.junit.Test;

public class FileLockTest {

    @Test
    public void createObject() {
        FileLock lock = new FileLock("c:\\temp\\foo");
        assertNotNull(lock);
    }

    @Test
    public void createLockWithSuccess() {
        FileLock lock = new FileLock("c:\\temp\\foo");
        boolean success = lock.lock();
        assertTrue(success);
    }

    @Test
    public void createTwoTimesLockWithoutSuccess() {
        FileLock lock = new FileLock("c:\\temp\\foo");
        boolean success = lock.lock();
        assertTrue(success);
        success = lock.lock();
        assertFalse(success);
        success = lock.unlock();
        assertTrue(success);
    }

    @Test
    public void createAndReleaseLockWithSuccess() {
        FileLock lock = new FileLock("c:\\temp\\foo");
        boolean success = lock.lock();
        assertTrue(success);
        success = lock.unlock();
        assertTrue(success);
    }

    @Test
    public void releaseLockWithoutCreationWithoutSuccess() {
        FileLock lock = new FileLock("c:\\temp\\foo");
        boolean success = lock.unlock();
        assertFalse(success);
    }

    @Test
    public void twoTimesCreateAndReleaseLockWithSuccess() {
        FileLock lock = new FileLock("c:\\temp\\foo");
        boolean success = lock.lock();
        assertTrue(success);
        success = lock.unlock();
        assertTrue(success);

        success = lock.lock();
        assertTrue(success);
        success = lock.unlock();
        assertTrue(success);
    }

}
